/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.helper;

import java.util.List;
import java.util.Random;
import net.jelly.sandworm_mod.advancements.AdvancementTriggerRegistry;
import net.jelly.sandworm_mod.capabilities.wormsign.WormSignProvider;
import net.jelly.sandworm_mod.entity.IK.worm.WormChainEntity;
import net.jelly.sandworm_mod.entity.ModEntities;
import net.jelly.sandworm_mod.helper.BiomeHelper;
import net.jelly.sandworm_mod.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.network.screenshake.ScreenshakePacket;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.systems.easing.Easing;

public class WarningSpawnHelper {
    public static void warningScreenshake(Player player, double strength, SoundEvent sound, int stage, int wormsign) {
        player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.MASTER, 12.5f, 1.0f, 0L);
        List nearbyPlayers = player.m_9236_().m_45955_(TargetingConditions.m_148353_(), null, new AABB(player.m_20182_().m_82520_(200.0, 500.0, 200.0), player.m_20182_().m_82492_(200.0, 500.0, 200.0)));
        nearbyPlayers.forEach(p -> {
            LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)p), (Object)new ScreenshakePacket(410).setEasing(Easing.SINE_IN_OUT).setIntensity((float)strength));
            player.getCapability(WormSignProvider.WS).ifPresent(ws -> {
                ws.setStage(stage);
                ws.setWS(wormsign);
                ws.setSignTimer();
            });
        });
    }

    public static void thumperWarning(Level level, Vec3 pos) {
        double strength = 0.6;
        level.m_214150_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.WORM_WARNING_2.get(), SoundSource.MASTER, 12.5f, 1.0f, 0L);
        List nearbyPlayers = level.m_45955_(TargetingConditions.m_148353_(), null, new AABB(pos.m_82520_(200.0, 500.0, 200.0), pos.m_82492_(200.0, 500.0, 200.0)));
        nearbyPlayers.forEach(p -> LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)p), (Object)new ScreenshakePacket(410).setEasing(Easing.SINE_IN_OUT).setIntensity((float)strength)));
    }

    private static Vec3 spawnPosOffset() {
        Random random = new Random();
        float xOffset = random.nextInt(100) + 100;
        if (random.nextBoolean()) {
            xOffset *= -1.0f;
        }
        float zOffset = random.nextInt(100) + 100;
        if (random.nextBoolean()) {
            zOffset *= -1.0f;
        }
        float yOffset = -5.0f;
        return new Vec3((double)xOffset, (double)yOffset, (double)zOffset);
    }

    public static void spawnWorm(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        WormChainEntity sandWorm = new WormChainEntity((EntityType)ModEntities.WORM_CHAIN.get(), player.m_9236_());
        Vec3 sandWormSpawnPos = player.m_20182_().m_82549_(WarningSpawnHelper.spawnPosOffset());
        int spawnChecks = 0;
        while (!BiomeHelper.isDesertBiome(player.m_20194_().m_129880_(player.m_9236_().m_46472_()).m_6018_(), new BlockPos((int)sandWormSpawnPos.f_82479_, (int)sandWormSpawnPos.f_82480_, (int)sandWormSpawnPos.f_82481_))) {
            sandWormSpawnPos = player.m_20182_().m_82549_(WarningSpawnHelper.spawnPosOffset());
            if (++spawnChecks <= 100) continue;
        }
        sandWorm.m_20219_(sandWormSpawnPos);
        sandWorm.setAggroTargetEntity((LivingEntity)player);
        player.m_9236_().m_7967_((Entity)sandWorm);
        sandWorm.m_5496_((SoundEvent)ModSounds.WORM_SPAWN.get(), 100.0f, 1.0f);
        AdvancementTriggerRegistry.SHAI_HULUD.trigger((ServerPlayer)player);
    }

    public static WormChainEntity spawnWormThumper(Level level, BlockPos bPos) {
        if (level.m_5776_()) {
            return null;
        }
        Vec3 pos = bPos.m_252807_();
        WormChainEntity sandWorm = new WormChainEntity((EntityType)ModEntities.WORM_CHAIN.get(), level);
        Vec3 sandWormSpawnPos = pos.m_82549_(WarningSpawnHelper.spawnPosOffset());
        int spawnChecks = 0;
        while (!BiomeHelper.isDesertBiome(level.m_7654_().m_129880_(level.m_46472_()), new BlockPos((int)sandWormSpawnPos.f_82479_, (int)sandWormSpawnPos.f_82480_, (int)sandWormSpawnPos.f_82481_))) {
            sandWormSpawnPos = pos.m_82549_(WarningSpawnHelper.spawnPosOffset());
            if (++spawnChecks <= 100) continue;
        }
        sandWorm.m_20219_(sandWormSpawnPos);
        sandWorm.thumperTarget = pos;
        level.m_7967_((Entity)sandWorm);
        sandWorm.m_5496_((SoundEvent)ModSounds.WORM_SPAWN.get(), 100.0f, 1.0f);
        return sandWorm;
    }
}

