/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.event;

import net.jelly.sandworm_mod.capabilities.wormsign.WormSign;
import net.jelly.sandworm_mod.capabilities.wormsign.WormSignProvider;
import net.jelly.sandworm_mod.config.CommonConfigs;
import net.jelly.sandworm_mod.entity.IK.worm.WormChainEntity;
import net.jelly.sandworm_mod.helper.BiomeHelper;
import net.jelly.sandworm_mod.helper.WarningSpawnHelper;
import net.jelly.sandworm_mod.sound.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sandworm_mod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WormSignHandler {
    @SubscribeEvent
    public static void tickWS(TickEvent.PlayerTickEvent event) {
        int spawnWorm = (Integer)CommonConfigs.SPAWNWORM_WORMSIGN.get();
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        Player player = event.player;
        if (!BiomeHelper.isDesertBiome(player.m_20194_().m_129880_(player.m_9236_().m_46472_()), player.m_20183_()) || player.m_9236_().m_45517_(LightLayer.SKY, player.m_20183_()) <= 0) {
            player.getCapability(WormSignProvider.WS).ifPresent(ws -> WormSignHandler.decrementWormSign(1, ws));
            return;
        }
        if (!player.m_9236_().m_45976_(WormChainEntity.class, new AABB(player.m_20182_().m_82520_(600.0, 200.0, 600.0), player.m_20182_().m_82492_(600.0, 200.0, 600.0))).isEmpty()) {
            player.getCapability(WormSignProvider.WS).ifPresent(ws -> {
                ws.setStage(0);
                ws.setStageTimer(0);
                ws.subWS(2 * spawnWorm);
                ws.setMultiplier(0.0);
                ws.setRespawnTimer((Integer)CommonConfigs.RESPAWN_DURATION.get() * 40);
            });
            return;
        }
        int softBoots = player.m_6844_(EquipmentSlot.FEET).getEnchantmentLevel(Enchantments.f_44967_);
        player.getCapability(WormSignProvider.WS).ifPresent(ws -> {
            System.out.println(ws.getWS());
            if (!ws.canRespawn()) {
                ws.decrementRespawnTimer();
                return;
            }
            if (ws.getSignTimer() < 200) {
                if (player.m_20142_()) {
                    WormSignHandler.incrementWormSign(4 - softBoots, player, ws);
                }
                ws.addThisJumpTime(1);
                ws.addMultiplier(-0.01);
                if (ws.getSignTimer() == 0) {
                    WormSignHandler.decrementWormSign(1, ws);
                }
                if (ws.getWS() >= spawnWorm) {
                    ws.setWS(0);
                    WarningSpawnHelper.spawnWorm(player);
                }
            }
            ws.decrementSignTimer();
        });
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        int softBoots = player.m_6844_(EquipmentSlot.FEET).getEnchantmentLevel(Enchantments.f_44967_);
        if (!BiomeHelper.isDesertBiome(player.m_20194_().m_129880_(player.m_9236_().m_46472_()), player.m_20183_()) || player.m_9236_().m_45517_(LightLayer.SKY, player.m_20183_()) <= 0) {
            return;
        }
        player.getCapability(WormSignProvider.WS).ifPresent(ws -> {
            if (ws.getSignTimer() < 200) {
                float lastJump = ws.getLastJumpTime();
                float thisJump = ws.getThisJumpTime();
                float percentDiff = Math.abs(lastJump - thisJump) / ((lastJump + thisJump) / 2.0f);
                float similarity = 1.0f - percentDiff;
                ws.addMultiplier((double)similarity * 0.7);
                WormSignHandler.incrementWormSign((int)(80.0 * ws.getMultiplier() * (1.0 - (double)softBoots / 16.0)), player, ws);
                ws.setLastJumpTime(ws.getThisJumpTime());
                ws.setThisJumpTime(0);
            }
        });
    }

    private static void incrementWormSign(int add, Player player, WormSign ws) {
        int spawnWorm = (Integer)CommonConfigs.SPAWNWORM_WORMSIGN.get();
        if (ws.getWS() < spawnWorm / 2 && ws.getWS() + add >= spawnWorm / 2) {
            WarningSpawnHelper.warningScreenshake(player, 0.5, (SoundEvent)ModSounds.WORM_WARNING_1.get(), ws.getStage(), ws.getWS());
            ws.setStage(1);
            ws.setStageTimer(600);
            ws.setSignTimer();
        } else if ((double)ws.getWS() < (double)spawnWorm * 0.8 && (double)(ws.getWS() + add) >= (double)spawnWorm * 0.8) {
            WarningSpawnHelper.warningScreenshake(player, 0.6, (SoundEvent)ModSounds.WORM_WARNING_2.get(), ws.getStage(), ws.getWS());
            ws.setStage(2);
            ws.setStageTimer(600);
            ws.setSignTimer();
        }
        ws.addWS(add);
    }

    private static void decrementWormSign(int decrement, WormSign ws) {
        int spawnWorm = (Integer)CommonConfigs.SPAWNWORM_WORMSIGN.get();
        if (ws.getStage() == 0) {
            ws.subWS(decrement);
            ws.setStageTimer(0);
        } else if (ws.getStage() == 1) {
            if (ws.getWS() - decrement >= spawnWorm / 2) {
                ws.subWS(decrement);
            } else {
                ws.setWS(spawnWorm / 2);
            }
            ws.decrementStageTimer();
            if (ws.dropStage()) {
                ws.setStage(0);
            }
        } else if (ws.getStage() == 2) {
            if ((double)(ws.getWS() - decrement) >= (double)spawnWorm * 0.8) {
                ws.subWS(decrement);
            } else {
                ws.setWS((int)((double)spawnWorm * 0.8));
            }
            ws.decrementStageTimer();
            if (ws.dropStage()) {
                ws.setStage(1);
            }
        }
    }
}

