/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.event;

import java.util.List;
import net.jelly.sandworm_mod.advancements.AdvancementTriggerRegistry;
import net.jelly.sandworm_mod.capabilities.wormsign.WormSignProvider;
import net.jelly.sandworm_mod.config.CommonConfigs;
import net.jelly.sandworm_mod.entity.IK.worm.WormChainEntity;
import net.jelly.sandworm_mod.entity.IK.worm.WormHeadSegment;
import net.jelly.sandworm_mod.sound.ModSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sandworm_mod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    @SubscribeEvent
    public static void RegisterModCommands(RegisterCommandsEvent event) {
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(WormSignProvider.WS).isPresent()) {
            event.addCapability(new ResourceLocation("sandworm_mod", "properties"), (ICapabilityProvider)new WormSignProvider());
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Vec3 pos = event.getExplosion().getPosition();
        List hitHeads = event.getLevel().m_45976_(WormHeadSegment.class, new AABB(pos.f_82479_ + 5.0, pos.f_82480_ + 5.0, pos.f_82481_ + 5.0, pos.f_82479_ - 5.0, pos.f_82480_ - 5.0, pos.f_82481_ - 5.0));
        if (!hitHeads.isEmpty()) {
            hitHeads.forEach(head -> {
                LivingEntity sourcePlayer;
                head.m_5496_((SoundEvent)ModSounds.WORM_ROAR.get(), 10.0f, 1.0f);
                WormChainEntity wormChain = head.getOwner();
                if (wormChain != null) {
                    wormChain.blastHit();
                }
                if ((sourcePlayer = event.getExplosion().m_252906_()) == null) {
                    Vec3 explosionPos = event.getExplosion().getPosition();
                    sourcePlayer = event.getLevel().m_45924_(explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_, 100.0, true);
                }
                if (sourcePlayer instanceof Player) {
                    AdvancementTriggerRegistry.FIRST_BLAST.trigger((ServerPlayer)sourcePlayer);
                    if (wormChain.explodedTimes >= (Integer)CommonConfigs.HEALTH.get()) {
                        AdvancementTriggerRegistry.SANDWORM_FLEE.trigger((ServerPlayer)sourcePlayer);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void brewPotion(PlayerBrewedPotionEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getStack().m_41783_().m_128471_("duneElixir")) {
            AdvancementTriggerRegistry.DUNE_ELIXIR.trigger((ServerPlayer)event.getEntity());
        }
    }
}

