/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.entity.IK.worm;

import java.util.List;
import java.util.UUID;
import net.jelly.sandworm_mod.config.CommonConfigs;
import net.jelly.sandworm_mod.entity.IK.ChainSegment;
import net.jelly.sandworm_mod.entity.IK.worm.WormChainEntity;
import net.jelly.sandworm_mod.registry.common.DamageTypesRegistry;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

public class WormSegment
extends ChainSegment
implements GeoEntity {
    private static int STAGE_TRACK = 0;
    private static int STAGE_BURROW = 1;
    private int stage = 0;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private UUID ownerEntityUUID;
    private int discardTimer = 0;
    private DamageSource dmgSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypesRegistry.WORM));

    public WormSegment(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_20182_().m_82549_(this.getDirectionVector()));
        if (!this.m_9236_().m_5776_()) {
            if (this.getOwner() == null) {
                if (this.discardTimer < 120) {
                    ++this.discardTimer;
                } else {
                    this.m_146870_();
                }
            } else {
                this.discardTimer = 0;
            }
            List collidingEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_());
            for (int i = 0; i < collidingEntities.size(); ++i) {
                if (!(collidingEntities.get(i) instanceof LivingEntity)) continue;
                LivingEntity target = (LivingEntity)collidingEntities.get(i);
                if (target.f_20916_ != 0) continue;
                Vec3 vec3 = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                target.m_6469_(this.dmgSource, (float)this.getDamage());
                Vec3 knockback = this.getKB();
                target.m_246865_(new Vec3(vec3.f_82479_ * knockback.f_82479_, vec3.f_82480_ * knockback.f_82480_, vec3.f_82481_ * knockback.f_82481_));
            }
        }
    }

    protected double getDamage() {
        return 10.0 * (Double)CommonConfigs.DAMAGE_SCALE.get();
    }

    protected Vec3 getKB() {
        return new Vec3(3.0, 2.0, 3.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.ownerEntityUUID = pCompound.m_128342_("chain_entity_UUID");
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128362_("chain_entity_UUID", this.ownerEntityUUID);
    }

    public void setOwnerEntityUUID(UUID uuid) {
        this.ownerEntityUUID = uuid;
    }

    public WormChainEntity getOwner() {
        List nearbyChainEntities = this.m_9236_().m_45976_(WormChainEntity.class, new AABB(this.m_20182_().m_82520_(200.0, 200.0, 200.0), this.m_20182_().m_82520_(-200.0, -200.0, -200.0)));
        return nearbyChainEntities.stream().filter(obj -> obj.m_20149_().equals(this.ownerEntityUUID.toString())).findFirst().orElse(null);
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }
}

