/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.entity.IK.worm;

import java.util.List;
import java.util.UUID;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.jelly.sandworm_mod.block.ModBlockEntities;
import net.jelly.sandworm_mod.config.CommonConfigs;
import net.jelly.sandworm_mod.entity.IK.ChainSegment;
import net.jelly.sandworm_mod.entity.IK.KinematicChainEntity;
import net.jelly.sandworm_mod.entity.IK.worm.WormHeadSegment;
import net.jelly.sandworm_mod.entity.IK.worm.WormSegment;
import net.jelly.sandworm_mod.entity.ModEntities;
import net.jelly.sandworm_mod.helper.BiomeHelper;
import net.jelly.sandworm_mod.item.ModItems;
import net.jelly.sandworm_mod.sound.ModSounds;
import net.jelly.sandworm_mod.worldevents.SonicBoomWorldEvent;
import net.jelly.sandworm_mod.worldevents.WormBreachWorldEvent;
import net.jelly.sandworm_mod.worldevents.WormRippleWorldEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.network.screenshake.PositionedScreenshakePacket;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class WormChainEntity
extends KinematicChainEntity {
    private static float SPEED_SCALE = 1.3f;
    private boolean breaching = false;
    private int soundFrequencyCount = 0;
    private static final ParticleEmitterInfo SAND_IMPACT = new ParticleEmitterInfo(new ResourceLocation("sandworm_mod", "sandimpact"));
    private static final ParticleEmitterInfo SLOWER_SAND_IMPACT = new ParticleEmitterInfo(new ResourceLocation("sandworm_mod", "slowersandimpact"));
    private static final ParticleEmitterInfo SAND_SMOKE = new ParticleEmitterInfo(new ResourceLocation("sandworm_mod", "sandsmoke"));
    public LivingEntity aggroTargetEntity;
    public boolean removed = false;
    private int discardTimer = 0;
    private int noTargetEscapeTimer = 0;
    private boolean escaping = false;
    private int noPlayerDiscardTimer = 0;
    private boolean isChasing = false;
    public int explodedTimes = 0;
    private WormHeadSegment head;
    public Vec3 thumperTarget = null;
    private int despawnTimer = 0;
    private int smokeCount = 0;

    public WormChainEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    private void initWorm() {
        if (this.segmentCount == 0) {
            Vec3 targetedObjectPos;
            int i;
            for (i = 0; i < 10; ++i) {
                this.addWormSegment(1.75f, new Vec3(1.0, 0.0, 0.0), new Vec3(7.5 * (double)((float)(i + 2) / 11.0f), 7.5 * (double)((float)(i + 2) / 11.0f), 5.0));
            }
            for (i = 0; i < 80; ++i) {
                this.addWormSegment(1.75f, new Vec3(1.0, 0.0, 0.0), new Vec3(7.5, 7.5, 5.0));
            }
            this.addHeadSegment(1.75f, new Vec3(1.0, 0.0, 0.0), new Vec3(7.5, 7.5, 5.0));
            if (this.aggroTargetEntity == null && this.thumperTarget == null) {
                this.retarget(30.0f);
            }
            if ((targetedObjectPos = this.getTargetedObjectPos()) != null) {
                Vec3 lookAtAggroEntity = targetedObjectPos.m_82546_(this.m_20182_()).m_82541_();
                for (int i2 = 0; i2 < this.segmentCount; ++i2) {
                    ((ChainSegment)((Object)this.segments.get(i2))).setDirectionVector(lookAtAggroEntity);
                }
            }
        }
    }

    private void loadSavedSegments() {
        if (this.segmentCount != 0 && this.segments.isEmpty()) {
            List nearbyChainSegs = this.m_9236_().m_45976_(ChainSegment.class, new AABB(this.m_20182_().m_82520_(200.0, 200.0, 200.0), this.m_20182_().m_82520_(-200.0, -200.0, -200.0)));
            for (int i = 0; i < this.segmentCount; ++i) {
                UUID thisUUID = (UUID)this.segmentsUUIDs.get(i);
                this.segments.add(nearbyChainSegs.stream().filter(obj -> obj.m_20149_().equals(thisUUID.toString())).findFirst().orElse(null));
            }
        }
    }

    private int despawnBehavior() {
        for (int j = 0; j < this.segments.size(); ++j) {
            if (this.segments.get(j) != null) continue;
            if (this.discardTimer < 100) {
                ++this.discardTimer;
            } else {
                this.m_146870_();
            }
            return 1;
        }
        this.discardTimer = 0;
        if (this.m_9236_().m_45930_((Entity)this, 400.0) == null) {
            if (this.noPlayerDiscardTimer < 60) {
                ++this.noPlayerDiscardTimer;
            } else {
                this.m_146870_();
            }
            return 1;
        }
        this.noPlayerDiscardTimer = 0;
        return 0;
    }

    private void fikBehavior() {
        if (!this.segments.isEmpty()) {
            this.m_146884_(((ChainSegment)((Object)this.segments.get(0))).m_20182_());
            Vec3 rootToEnd = ((ChainSegment)((Object)this.segments.get(this.segmentCount - 1))).m_20182_().m_82546_(((ChainSegment)((Object)this.segments.get(0))).m_20182_()).m_82537_(new Vec3(0.0, 0.0, 1.0));
            for (int i = 0; i < this.segmentCount; ++i) {
                if (this.segments.get(i) == null) continue;
                ((ChainSegment)((Object)this.segments.get(i))).setUpVector(rootToEnd);
            }
        }
    }

    private void dolphinBehavior() {
        Vec3 targetedObjectPos = this.getTargetedObjectPos();
        if (!this.isChasing) {
            Vec3 towardTarget = targetedObjectPos.m_82546_(this.head.m_20182_()).m_82541_().m_82542_(20.0, 0.0, 20.0);
            this.goal = this.head.m_20182_().m_82520_(towardTarget.f_82479_, 0.0, towardTarget.f_82481_);
            this.goal = new Vec3(this.goal.f_82479_, targetedObjectPos.f_82480_, this.goal.f_82481_);
            this.isChasing = true;
        } else if (this.head.m_20182_().m_82546_(this.goal).m_165924_() <= 10.0) {
            Vec3 towardTarget = targetedObjectPos.m_82546_(this.head.m_20182_()).m_82541_().m_82542_(20.0, 0.0, 20.0);
            this.goal = this.head.m_20182_().m_82520_(towardTarget.f_82479_, 0.0, towardTarget.f_82481_);
            this.goal = new Vec3(this.goal.f_82479_, targetedObjectPos.f_82480_, this.goal.f_82481_);
        }
    }

    private void VFXSFXBehavior() {
        List players = this.m_9236_().m_6907_();
        if (this.m_9236_().m_186437_(null, this.head.m_20191_())) {
            float intensity;
            for (int i = 0; i < players.size(); ++i) {
                Player thisPlayer = (Player)players.get(i);
                float dist = thisPlayer.m_20270_((Entity)this.head);
                if (!(dist <= 100.0f)) continue;
                intensity = (float)Math.pow(1.0 + Math.pow(1.1f, dist - 17.5f), -1.0) + 0.2f;
                LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)thisPlayer), (Object)new PositionedScreenshakePacket(20, this.head.m_20182_(), 200.0f, 100.0f).setEasing(Easing.CUBIC_OUT).setIntensity(0.65f * intensity, 0.0f));
            }
            Vec3 targetedObjectPos = this.getTargetedObjectPos();
            if (targetedObjectPos != null) {
                double dist = targetedObjectPos.m_82554_(this.head.m_20182_());
                intensity = (float)Math.pow(1.0 + Math.pow(1.1f, dist - 17.5), -1.0) + 0.2f;
                if ((float)this.soundFrequencyCount >= 10.0f - intensity * 10.0f) {
                    this.m_9236_().m_6269_(null, (Entity)this.head, SoundEvents.f_12331_, SoundSource.HOSTILE, 80.0f * intensity, intensity);
                    this.head.m_5496_((SoundEvent)ModSounds.WORM_BURROW.get(), 80.0f * intensity, intensity);
                    this.soundFrequencyCount = 0;
                } else {
                    ++this.soundFrequencyCount;
                }
            }
        }
        if (!this.breaching && this.predictBreach(this.m_9236_(), this.head)) {
            this.breaching = true;
            particlePos = this.head.m_20182_().m_82549_(this.head.getDirectionVector().m_82490_(8.0));
            AAALevel.addParticle((Level)this.m_9236_(), (boolean)true, (ParticleEmitterInfo)SLOWER_SAND_IMPACT.clone().scale(1.25f).position(particlePos));
            this.smokeParticles(this.m_9236_(), particlePos.m_82520_(0.0, -9.0, 0.0));
            if (!this.escaping) {
                this.m_5496_((SoundEvent)ModSounds.WORM_BREACH.get(), 10.0f, 1.0f);
            }
        } else if (this.breaching && !this.predictBreach(this.m_9236_(), this.head)) {
            this.breaching = false;
            particlePos = this.head.m_20182_().m_82549_(this.head.getDirectionVector().m_82490_(8.0));
            AAALevel.addParticle((Level)this.m_9236_(), (boolean)true, (ParticleEmitterInfo)SLOWER_SAND_IMPACT.clone().scale(1.25f).position(particlePos));
            this.smokeParticles(this.m_9236_(), particlePos.m_82520_(0.0, -9.0, 0.0));
            if (!this.escaping) {
                this.m_5496_((SoundEvent)ModSounds.WORM_LAND.get(), 10.0f, 1.0f);
            }
        }
    }

    private void wormAIBehavior() {
        if (this.thumperTarget == null && (this.aggroTargetEntity == null || this.aggroTargetEntity.m_213877_() || this.aggroTargetEntity.m_21224_() || !BiomeHelper.isDesertBiome((Entity)this.aggroTargetEntity))) {
            this.retarget(30.0f);
            if (this.noTargetEscapeTimer >= 20) {
                this.escaping = true;
            }
        } else if (!this.escaping) {
            Vec3 targetedObjectPos = this.getTargetedObjectPos();
            if (targetedObjectPos == null) {
                this.target = this.head.m_20182_().m_82549_(this.targetV);
                return;
            }
            if (this.head.m_20182_().m_82546_(targetedObjectPos).m_165924_() > 50.0) {
                this.dolphinBehavior();
            } else {
                this.isChasing = false;
            }
            if (!this.isChasing) {
                if (this.stage != 0 || !(targetedObjectPos.m_82554_(this.head.m_20182_()) < (double)(22.0f * SPEED_SCALE))) {
                    this.goal = targetedObjectPos;
                } else if (this.goal == null) {
                    this.goal = targetedObjectPos;
                } else if (this.stage == 0) {
                    this.sinkHole(this.m_9236_(), this.goal);
                }
            }
            this.target = this.head.m_20182_().m_82549_(this.targetV);
            Vec3 moveTowardVec = this.goal.m_82546_(this.head.m_20182_()).m_82541_();
            if (this.stage == 0) {
                this.applyAcceleration(moveTowardVec.m_82490_(0.1 * (double)SPEED_SCALE));
                if (moveTowardVec.m_82526_(this.head.getDirectionVector()) < 0.25 || !this.m_9236_().m_186437_(null, this.head.m_20191_())) {
                    this.stage = 1;
                }
            }
            if (this.stage == 1) {
                if (!this.m_9236_().m_186437_(null, this.head.m_20191_())) {
                    if (targetedObjectPos.f_82480_ - this.head.m_20182_().f_82480_ > 30.0) {
                        this.retarget(30.0f);
                    }
                    this.applyAcceleration(new Vec3(0.0, -0.0375, 0.0));
                    if (moveTowardVec.f_82480_ < 0.0) {
                        moveTowardVec = new Vec3(moveTowardVec.f_82479_, 0.0, moveTowardVec.f_82481_);
                    }
                    if (this.goal.f_82480_ - this.head.m_20182_().f_82480_ < 20.0) {
                        this.applyAcceleration(moveTowardVec.m_82490_(0.01));
                    }
                } else if (this.head.m_20182_().m_82554_(this.goal) > (double)(4.0f * SPEED_SCALE) && this.goal.f_82480_ - this.head.m_20182_().f_82480_ >= (double)(20.0f * SPEED_SCALE)) {
                    this.stage = 0;
                } else {
                    this.applyAcceleration(new Vec3(0.0, -0.02 * (double)SPEED_SCALE, 0.0));
                }
            }
        }
        if (this.escaping) {
            this.applyAcceleration(new Vec3(0.0, -0.0375, 0.0));
            this.target = this.head.m_20182_().m_82549_(this.targetV);
        }
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            this.loadSavedSegments();
            if (this.despawnBehavior() == 1) {
                return;
            }
            this.initWorm();
            this.fikBehavior();
            if (this.aggroTargetEntity != null) {
                this.despawnTimer = !(this.aggroTargetEntity instanceof Player) ? ++this.despawnTimer : (((Player)this.aggroTargetEntity).m_7500_() ? ++this.despawnTimer : 0);
                if (this.despawnTimer >= (Integer)CommonConfigs.DESPAWN_TIMER.get() * 20) {
                    this.escaping = true;
                }
            }
            if (!this.segments.isEmpty()) {
                BlockPos thumperBPos;
                if (this.head == null && ((Object)((Object)((ChainSegment)((Object)this.segments.get(this.segmentCount - 1))))).getClass() == WormHeadSegment.class) {
                    this.head = (WormHeadSegment)((Object)this.segments.get(this.segmentCount - 1));
                }
                if (this.thumperTarget != null && this.head.m_20039_(thumperBPos = BlockPos.m_274561_((double)this.thumperTarget.f_82479_, (double)this.thumperTarget.f_82480_, (double)this.thumperTarget.f_82481_), this.m_9236_().m_8055_(thumperBPos))) {
                    this.m_9236_().m_46961_(thumperBPos, false);
                }
                this.wormAIBehavior();
                this.VFXSFXBehavior();
                this.fabrik();
            }
        }
    }

    private void retarget(float yRange) {
        double deltaY;
        double distanceSq;
        double deltaZ;
        double deltaX;
        Vec3 headPos = ((ChainSegment)((Object)this.segments.get(this.segmentCount - 1))).m_20182_();
        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(headPos.f_82479_ + 150.0, headPos.f_82480_ + 150.0, headPos.f_82481_ + 150.0, headPos.f_82479_ - 150.0, headPos.f_82480_ - 150.0, headPos.f_82481_ - 150.0));
        List nearbyPlayers = this.m_9236_().m_45955_(TargetingConditions.m_148353_(), null, new AABB(headPos.f_82479_ + 150.0, headPos.f_82480_ + 150.0, headPos.f_82481_ + 150.0, headPos.f_82479_ - 150.0, headPos.f_82480_ - 150.0, headPos.f_82481_ - 150.0));
        Player closestEntity = null;
        double closestDistanceSq = Double.MAX_VALUE;
        Player farthestTooCloseEntity = null;
        double fartestTooCloseDistanceSq = 0.0;
        for (Player entity : nearbyPlayers) {
            if (!BiomeHelper.isDesertBiome((Entity)entity) || this.m_9236_().m_45517_(LightLayer.SKY, entity.m_20183_()) <= 0 || entity.m_5833_() || entity.m_7500_()) continue;
            deltaX = entity.m_20185_() - headPos.f_82479_;
            deltaZ = entity.m_20189_() - headPos.f_82481_;
            distanceSq = deltaX * deltaX + deltaZ * deltaZ;
            deltaY = entity.m_20186_() - headPos.f_82480_;
            if (distanceSq >= 400.0 && deltaY <= (double)yRange) {
                if (!(distanceSq < closestDistanceSq)) continue;
                closestDistanceSq = distanceSq;
                closestEntity = entity;
                continue;
            }
            if (!(deltaY <= (double)yRange) || !(distanceSq > fartestTooCloseDistanceSq)) continue;
            fartestTooCloseDistanceSq = distanceSq;
            farthestTooCloseEntity = entity;
        }
        if (closestEntity == null & farthestTooCloseEntity == null) {
            closestDistanceSq = Double.MAX_VALUE;
            fartestTooCloseDistanceSq = 0.0;
            for (Player entity : nearbyEntities) {
                if (!BiomeHelper.isDesertBiome((Entity)entity) || this.m_9236_().m_45517_(LightLayer.SKY, entity.m_20183_()) <= 0) continue;
                deltaX = entity.m_20185_() - headPos.f_82479_;
                deltaZ = entity.m_20189_() - headPos.f_82481_;
                distanceSq = deltaX * deltaX + deltaZ * deltaZ;
                deltaY = entity.m_20186_() - headPos.f_82480_;
                if (distanceSq >= 400.0 && deltaY <= (double)yRange) {
                    if (!(distanceSq < closestDistanceSq)) continue;
                    closestDistanceSq = distanceSq;
                    closestEntity = entity;
                    continue;
                }
                if (!(deltaY <= (double)yRange) || !(distanceSq > fartestTooCloseDistanceSq)) continue;
                fartestTooCloseDistanceSq = distanceSq;
                farthestTooCloseEntity = entity;
            }
        }
        if (closestEntity == null) {
            closestEntity = farthestTooCloseEntity;
        }
        this.aggroTargetEntity = closestEntity;
        this.noTargetEscapeTimer = closestEntity == null ? ++this.noTargetEscapeTimer : 0;
    }

    private boolean predictBreach(Level level, WormSegment head) {
        Vec3 targetedObjectPos = this.getTargetedObjectPos();
        if (targetedObjectPos != null && targetedObjectPos.f_82480_ - head.m_20186_() > 20.0) {
            return false;
        }
        Vec3 futurePos = head.m_20182_().m_82549_(head.getDirectionVector().m_82490_(10.0));
        BlockPos futureBPos = new BlockPos((int)futurePos.f_82479_, (int)futurePos.f_82480_, (int)futurePos.f_82481_);
        return !level.m_8055_(futureBPos).m_60828_((BlockGetter)level, futureBPos) && !level.m_8055_(futureBPos).m_60713_(Blocks.f_50627_);
    }

    private void addWormSegment(float length, Vec3 dirVec, Vec3 scale) {
        if (!this.m_9236_().m_5776_()) {
            if (this.segments.isEmpty()) {
                WormSegment chainSegment = new WormSegment((EntityType)ModEntities.WORM_SEGMENT.get(), this.m_9236_());
                chainSegment.setLength(length);
                chainSegment.setDirectionVector(dirVec);
                chainSegment.setVisualScale(scale);
                chainSegment.setOwnerEntityUUID(this.m_20148_());
                Vec3 pos = this.m_20182_();
                chainSegment.m_20219_(pos);
                this.segments.add(chainSegment);
                this.segmentsUUIDs.add(chainSegment.m_20148_());
                this.m_9236_().m_7967_((Entity)chainSegment);
            } else {
                WormSegment chainSegment = new WormSegment((EntityType)ModEntities.WORM_SEGMENT.get(), this.m_9236_());
                chainSegment.setLength(length);
                chainSegment.setDirectionVector(dirVec);
                chainSegment.setVisualScale(scale);
                chainSegment.setOwnerEntityUUID(this.m_20148_());
                Vec3 pos = ((ChainSegment)((Object)this.segments.get(this.segments.size() - 1))).m_20182_();
                chainSegment.m_20219_(pos);
                this.segments.add(chainSegment);
                this.segmentsUUIDs.add(chainSegment.m_20148_());
                this.m_9236_().m_7967_((Entity)chainSegment);
            }
        }
        ++this.segmentCount;
    }

    private void addHeadSegment(float length, Vec3 dirVec, Vec3 scale) {
        if (!this.m_9236_().m_5776_()) {
            if (this.segments.isEmpty()) {
                System.err.println("worm head spawned not as last segment");
                return;
            }
            WormHeadSegment chainSegment = new WormHeadSegment((EntityType)ModEntities.WORM_HEAD_SEGMENT.get(), this.m_9236_());
            chainSegment.setLength(length);
            chainSegment.setDirectionVector(dirVec);
            chainSegment.setVisualScale(scale);
            chainSegment.setOwnerEntityUUID(this.m_20148_());
            Vec3 pos = ((ChainSegment)((Object)this.segments.get(this.segments.size() - 1))).m_20182_().m_82549_(dirVec.m_82541_().m_82490_((double)length));
            chainSegment.m_20219_(pos);
            this.segments.add(chainSegment);
            this.segmentsUUIDs.add(chainSegment.m_20148_());
            this.m_9236_().m_7967_((Entity)chainSegment);
        }
        ++this.segmentCount;
    }

    @Override
    public void fabrik() {
        for (int i = 0; Math.abs(this.target.m_82546_(((ChainSegment)((Object)this.segments.get(this.segmentCount - 1))).m_20182_()).m_82553_()) > (double)this.tolerance && i <= 10; ++i) {
            this.fabrikForward();
        }
    }

    @Override
    public void applyAcceleration(Vec3 accel) {
        super.applyAcceleration(accel);
        if (this.targetV.m_82553_() > (double)SPEED_SCALE) {
            this.targetV = this.targetV.m_82541_().m_82490_((double)SPEED_SCALE);
        }
    }

    public void blastHit() {
        this.targetV = new Vec3(this.targetV.f_82479_ * 0.075, this.targetV.f_82480_ + 1.2, this.targetV.f_82481_ * 0.075);
        this.sonicBoom();
        ++this.explodedTimes;
        if (this.explodedTimes >= (Integer)CommonConfigs.HEALTH.get()) {
            ItemEntity toothItem = new ItemEntity(this.m_9236_(), this.head.m_20185_(), this.head.m_20186_(), this.head.m_20189_(), new ItemStack((ItemLike)ModItems.WORM_TOOTH.get(), 1));
            this.m_9236_().m_7967_((Entity)toothItem);
            this.escaping = true;
        }
    }

    public void setAggroTargetEntity(LivingEntity target) {
        this.aggroTargetEntity = target;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (!this.m_9236_().m_5776_()) {
            for (int i = 0; i < this.segments.size(); ++i) {
                if (this.segments.get(i) == null) continue;
                ((ChainSegment)((Object)this.segments.get(i))).m_146870_();
            }
        }
        super.m_142687_(pReason);
    }

    private void smokeParticles(Level level, Vec3 pos) {
        ++this.smokeCount;
        WormBreachWorldEvent breachEvent = new WormBreachWorldEvent().setPosition(pos);
        breachEvent.start(level);
        breachEvent.setDirty();
        WorldEventHandler.addWorldEvent((Level)level, (WorldEventInstance)breachEvent);
    }

    private void sinkHole(Level level, Vec3 pos) {
        WormRippleWorldEvent breachEvent = new WormRippleWorldEvent().spawnRipple(pos);
        breachEvent.start(level);
        breachEvent.setDirty();
        WorldEventHandler.addWorldEvent((Level)level, (WorldEventInstance)breachEvent);
    }

    private void sonicBoom() {
        if (this.head == null) {
            return;
        }
        SonicBoomWorldEvent breachEvent = new SonicBoomWorldEvent().spawnRipple(this.head);
        breachEvent.start(this.m_9236_());
        breachEvent.setDirty();
        WorldEventHandler.addWorldEvent((Level)this.m_9236_(), (WorldEventInstance)breachEvent);
        List players = this.m_9236_().m_6907_();
        players.forEach(player -> {
            float dist = player.m_20270_((Entity)this.head);
            if (dist <= 100.0f) {
                LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PositionedScreenshakePacket(80, this.head.m_20182_(), 200.0f, 100.0f).setEasing(Easing.CUBIC_OUT).setIntensity(0.85f));
            }
        });
    }

    private Vec3 getTargetedObjectPos() {
        if (this.thumperTarget != null) {
            BlockEntity thumper = this.m_9236_().getExistingBlockEntity(BlockPos.m_274561_((double)this.thumperTarget.f_82479_, (double)this.thumperTarget.f_82480_, (double)this.thumperTarget.f_82481_));
            if (thumper == null || thumper.m_58903_() != ModBlockEntities.THUMPER_ENTITY.get()) {
                this.thumperTarget = null;
            }
            return this.thumperTarget;
        }
        if (this.aggroTargetEntity != null) {
            return this.aggroTargetEntity.m_20182_();
        }
        return null;
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.removed = pCompound.m_128471_("removed");
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("removed", this.removed);
    }
}

