/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.entity.IK;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.jelly.sandworm_mod.entity.IK.ChainSegment;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class KinematicChainEntity
extends Entity {
    public float tolerance = 0.01f;
    public Vec3 target = new Vec3(0.0, 0.0, 0.0);
    protected Vec3 targetV = new Vec3(0.0, 0.0, 0.0);
    public Vec3 goal = null;
    public int segmentCount = 0;
    public List<ChainSegment> segments = new ArrayList<ChainSegment>();
    public List<UUID> segmentsUUIDs = new ArrayList<UUID>();
    public int stage = 0;

    public KinematicChainEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            int i;
            if (this.segmentCount != 0 && this.segments.isEmpty()) {
                List nearbyChainSegs = this.m_9236_().m_45976_(ChainSegment.class, new AABB(this.m_20182_().m_82520_(100.0, 100.0, 100.0), this.m_20182_().m_82520_(-100.0, -100.0, -100.0)));
                for (i = 0; i < this.segmentCount; ++i) {
                    UUID thisUUID = this.segmentsUUIDs.get(i);
                    this.segments.add(nearbyChainSegs.stream().filter(obj -> obj.m_20149_().equals(thisUUID.toString())).findFirst().orElse(null));
                }
            }
            if (!this.segments.isEmpty()) {
                this.m_146884_(this.segments.get(0).m_20182_());
                Vec3 rootToEnd = this.segments.get(this.segmentCount - 1).m_20182_().m_82546_(this.segments.get(0).m_20182_()).m_82537_(new Vec3(0.0, 0.0, 1.0));
                for (i = 0; i < this.segmentCount; ++i) {
                    if (this.segments.get(i) == null) continue;
                    this.segments.get(i).setUpVector(rootToEnd);
                }
            }
            if (this.segmentCount == 0) {
                for (int i2 = 0; i2 < 100; ++i2) {
                    this.addSegment(1.75f, new Vec3(0.0, 1.0, 0.0));
                }
            }
        }
    }

    public void fabrik() {
        int i;
        float totalLength = 0.0f;
        float distToTarget = (float)this.target.m_82546_(this.m_20182_()).m_82553_();
        for (i = 0; i < this.segmentCount; ++i) {
            totalLength += this.segments.get(i).getLength();
        }
        if (distToTarget > totalLength) {
            Vec3 rootToTarget = this.target.m_82546_(this.m_20182_()).m_82541_();
            for (int i2 = 0; i2 < this.segmentCount; ++i2) {
                ChainSegment currentSegment = this.segments.get(i2);
                Vec3 root = this.m_20182_();
                float length = currentSegment.getLength();
                Vec3 lastPosition = i2 == 0 ? root : this.segments.get(i2 - 1).m_20182_();
                currentSegment.m_146884_(lastPosition.m_82549_(rootToTarget.m_82490_((double)length)));
                currentSegment.setDirectionVector(rootToTarget);
            }
            return;
        }
        for (i = 0; Math.abs(this.target.m_82546_(this.segments.get(this.segmentCount - 1).m_20182_()).m_82553_()) > (double)this.tolerance && i <= 10; ++i) {
            this.fabrikForward();
        }
    }

    public void fabrikForward() {
        for (int i = this.segmentCount - 1; i >= 0; --i) {
            Vec3 lastPosition;
            ChainSegment currentSegment = this.segments.get(i);
            Vec3 root = this.m_20182_();
            if (i == 0) {
                lastPosition = root;
            } else {
                ChainSegment lastSegment = this.segments.get(i - 1);
                lastPosition = lastSegment.m_20182_();
            }
            if (i == this.segmentCount - 1) {
                currentSegment.m_146884_(this.target);
            } else {
                ChainSegment nextSegment = this.segments.get(i + 1);
                Vec3 nextTail = nextSegment.m_20182_().m_82546_(nextSegment.getDirectionVector().m_82490_((double)nextSegment.getLength()));
                currentSegment.m_146884_(nextTail);
            }
            currentSegment.setDirectionVector(currentSegment.m_20182_().m_82546_(lastPosition));
        }
    }

    public void fabrikBackward() {
        for (int i = 0; i < this.segmentCount; ++i) {
            Vec3 lastPosition;
            ChainSegment currentSegment = this.segments.get(i);
            Vec3 root = this.m_20182_();
            if (i == 0) {
                lastPosition = root;
            } else {
                ChainSegment lastSegment = this.segments.get(i - 1);
                lastPosition = lastSegment.m_20182_();
            }
            currentSegment.setDirectionVector(currentSegment.m_20182_().m_82546_(lastPosition));
            currentSegment.m_146884_(lastPosition.m_82549_(currentSegment.getDirectionVector().m_82490_((double)currentSegment.getLength())));
        }
    }

    private void addSegment(float length, Vec3 dirVec) {
    }

    public void applyAcceleration(Vec3 accel) {
        this.targetV = this.targetV.m_82549_(accel);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.segmentCount = pCompound.m_128451_("segment_count");
        this.segmentsUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < this.segmentCount; ++i) {
            UUID thisUUID = pCompound.m_128342_("segment_" + i);
            this.segmentsUUIDs.add(thisUUID);
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("segment_count", this.segmentCount);
        if (this.segmentCount != 0 && this.segmentsUUIDs.isEmpty()) {
            this.m_7378_(pCompound);
        }
        for (int i = 0; i < this.segmentCount; ++i) {
            pCompound.m_128362_("segment_" + i, this.segmentsUUIDs.get(i));
        }
    }
}

