/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.block;

import net.jelly.sandworm_mod.advancements.AdvancementTriggerRegistry;
import net.jelly.sandworm_mod.block.ModBlockEntities;
import net.jelly.sandworm_mod.block.ThumperBlock;
import net.jelly.sandworm_mod.config.CommonConfigs;
import net.jelly.sandworm_mod.entity.IK.worm.WormChainEntity;
import net.jelly.sandworm_mod.helper.BiomeHelper;
import net.jelly.sandworm_mod.helper.WarningSpawnHelper;
import net.jelly.sandworm_mod.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ThumperBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean thumping = false;
    private int wormSign = 0;
    private int pauseTicks = 0;
    private int soundTimer = 50;
    private boolean startAnimation = false;

    public ThumperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.THUMPER_ENTITY.get(), pPos, pBlockState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.startAnimation) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("thump"));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenWait(2));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ThumperBlockEntity e) {
        e.thumping = (Boolean)blockState.m_61143_((Property)ThumperBlock.THUMPING);
        if (e.thumping) {
            if (e.soundTimer == 40) {
                e.startAnimation = false;
            } else if (e.soundTimer == 52) {
                level.m_5594_(null, blockPos, (SoundEvent)ModSounds.THUMPER.get(), SoundSource.BLOCKS, 7.0f, 1.0f);
            }
            if (e.soundTimer >= 55) {
                e.startAnimation = true;
                e.soundTimer = 0;
            } else {
                ++e.soundTimer;
            }
        } else {
            e.soundTimer = 39;
        }
        if (level.m_5776_()) {
            return;
        }
        if (!level.m_8055_(blockPos.m_7495_()).m_280296_()) {
            level.m_46961_(blockPos, true);
        }
        if (e.pauseTicks > 0) {
            --e.pauseTicks;
            return;
        }
        if (!level.m_45976_(WormChainEntity.class, new AABB(blockPos.m_252807_().m_82520_(600.0, 200.0, 600.0), blockPos.m_252807_().m_82492_(600.0, 200.0, 600.0))).isEmpty()) {
            e.wormSign = 0;
            return;
        }
        if (e.thumping && BiomeHelper.isDesertBiome((ServerLevel)level, blockPos)) {
            ++e.wormSign;
        } else {
            if (e.wormSign > 0) {
                --e.wormSign;
            }
            return;
        }
        if (e.thumping && e.wormSign == (Integer)CommonConfigs.SPAWNWORM_WORMSIGN.get() / 20) {
            e.pauseTicks = 500;
            ++e.wormSign;
            WarningSpawnHelper.thumperWarning(level, blockPos.m_252807_());
        } else if (e.wormSign >= (Integer)CommonConfigs.SPAWNWORM_WORMSIGN.get() / 10) {
            e.wormSign = 0;
            e.pauseTicks = 500;
            WarningSpawnHelper.spawnWormThumper(level, blockPos);
            level.m_45955_(TargetingConditions.m_148353_(), null, new AABB(blockPos.m_7918_(50, 200, 50), blockPos.m_7918_(-50, -200, -50))).forEach(player -> AdvancementTriggerRegistry.THUMPER.trigger((ServerPlayer)player));
        }
    }
}

