/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf.shapes;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.zeith.hammerlib.util.AABBUtils;

public class ShapeUtils {
    public static VoxelShape rotateNorthShape(VoxelShape shape, Direction rotationIn) {
        return ShapeUtils.join(shape.m_83299_().stream().map(aabb -> AABBUtils.rotateNorthBox(aabb, rotationIn)).map(Shapes::m_83064_));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotationIn) {
        return ShapeUtils.join(shape.m_83299_().stream().map(aabb -> AABBUtils.rotate(aabb, rotationIn)).map(Shapes::m_83064_));
    }

    public static VoxelShape join(Stream<VoxelShape> boxes) {
        return boxes.reduce((a, b) -> Shapes.m_83148_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_)).map(VoxelShape::m_83296_).orElseGet(Shapes::m_83040_);
    }

    public static VoxelShape join(List<AABB> boxes) {
        VoxelShape ret = Shapes.m_83040_();
        for (AABB aabb : boxes) {
            ret = Shapes.m_83148_((VoxelShape)ret, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
        }
        return ret.m_83296_();
    }
}

