/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.properties.IBasePropertyHolder;

@MainThreaded
public class SendPropertiesPacket
implements IPacket {
    IObjectSource<?> source;
    byte[] data;

    public SendPropertiesPacket(IObjectSource<?> source, byte[] data) {
        this.source = source;
        this.data = data;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130079_(IObjectSource.writeSource(this.source));
        buf.writeShort(this.data.length);
        buf.writeBytes(this.data);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.source = IObjectSource.readSource(buf.m_130260_()).orElse(null);
        this.data = new byte[buf.readShort()];
        buf.readBytes(this.data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        IBasePropertyHolder tile;
        ClientLevel cw = Minecraft.m_91087_().f_91073_;
        if (cw != null && this.source != null && (tile = (IBasePropertyHolder)this.source.get(IBasePropertyHolder.class, (Level)cw).orElse(null)) != null) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.data));
            tile.getProperties().decodeChanges(buf);
        }
    }
}

