/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter.recipe;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.zeith.hammerlib.api.recipes.IngredientWithCount;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.recipe.RecipeGroup;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public abstract class AbstractRecipeBuilder<R extends AbstractRecipeBuilder<R>> {
    protected ResourceLocation identifier;
    protected String group = "";
    protected final IRecipeRegistrationEvent<Recipe<?>> event;

    public AbstractRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
        this.event = event;
    }

    public R id(ResourceLocation identifier) {
        this.identifier = identifier;
        return (R)this;
    }

    public R group(String group) {
        this.group = group;
        return (R)this;
    }

    public R group(RecipeGroup group) {
        this.group = group.toString();
        return (R)this;
    }

    public ResourceLocation getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        this.identifier = this.event.nextId(this.getResultIdentifier());
        return this.identifier;
    }

    protected abstract ResourceLocation getResultIdentifier();

    protected abstract void validate();

    protected abstract Recipe<?> createRecipe();

    public final void register() {
        this.validate();
        this.event.register(this.getIdentifier(), this.createRecipe());
    }

    public ResourceLocation registerAndGetId() {
        this.register();
        return this.getIdentifier();
    }

    public void registerIf(BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            this.register();
        }
    }

    public void registerIf(Predicate<ResourceLocation> condition) {
        if (condition.test(this.identifier)) {
            this.register();
        }
    }

    public Optional<ResourceLocation> registerIfAndGetId(BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            this.register();
            return Optional.of(this.getIdentifier());
        }
        return Optional.empty();
    }

    public Optional<ResourceLocation> registerIfAndGetId(Predicate<ResourceLocation> condition) {
        if (condition.test(this.identifier)) {
            this.register();
            return Optional.of(this.getIdentifier());
        }
        return Optional.empty();
    }

    protected Ingredient parseIngredient(Object obj) {
        return RecipeHelper.fromComponent(obj);
    }

    protected IngredientWithCount parseIngredient(Object obj, int count) {
        return new IngredientWithCount(RecipeHelper.fromComponent(obj), count);
    }
}

