/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.Rect2i;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.screen.IAdvancedComponent;

public class GuiObjectHelper {
    public static Object getIngredientUnderMouse(GuiRootObject object, double mouseX, double mouseY) {
        return GuiObjectHelper.getIngredientUnderMouse(object, object.myPose(), mouseX, mouseY);
    }

    public static List<Rect2i> getAllAreas(GuiRootObject object) {
        return GuiObjectHelper.getAllAreas(object, object.myPose());
    }

    public static Object getIngredientUnderMouse(GuiObject object, PoseStack pose, double mouseX, double mouseY) {
        Vector3f tp = new Vector3f();
        return object.findInTree(pose, IAdvancedComponent.class, (com, pos) -> {
            GuiObject.untransform(pos).transformPosition((float)mouseX, (float)mouseY, 0.0f, tp);
            Object ing = com.getIngredientUnderMouse(tp.x, tp.y);
            if (ing != null) {
                return Optional.of(ing);
            }
            return Optional.empty();
        }).orElse(null);
    }

    public static List<Rect2i> getAllAreas(GuiObject object, PoseStack pose) {
        ArrayList<Rect2i> rectangles = new ArrayList<Rect2i>();
        object.runForTree(pose, (com, pos) -> {
            Matrix4f mat = new Matrix4f((Matrix4fc)pos.m_85850_().m_252922_());
            com.getUnpositionedBounds().stream().map(r -> GuiObjectHelper.untransform(mat, r)).forEach(rectangles::add);
            if (com instanceof IAdvancedComponent) {
                IAdvancedComponent adv = (IAdvancedComponent)((Object)com);
                for (Rect2i r2 : adv.getExtraAreas()) {
                    r2 = GuiObjectHelper.untransform(mat, r2);
                    rectangles.add(r2);
                }
            }
        });
        return rectangles;
    }

    public static Rect2i untransform(Matrix4f mat, Rect2i src) {
        Vector3f p1 = mat.transformPosition((float)src.m_110085_(), (float)src.m_110086_(), 0.0f, new Vector3f());
        Vector3f p2 = mat.transformPosition((float)(src.m_110085_() + src.m_110090_() - 1), (float)src.m_110086_(), 0.0f, new Vector3f());
        Vector3f p3 = mat.transformPosition((float)(src.m_110085_() + src.m_110090_() - 1), (float)(src.m_110086_() + src.m_110091_() - 1), 0.0f, new Vector3f());
        Vector3f p4 = mat.transformPosition((float)src.m_110085_(), (float)(src.m_110086_() + src.m_110091_() - 1), 0.0f, new Vector3f());
        int minX = (int)Math.floor(Math.min(p1.x, Math.min(p2.x, Math.min(p3.x, p4.x))));
        int minY = (int)Math.floor(Math.min(p1.y, Math.min(p2.y, Math.min(p3.y, p4.y))));
        int maxX = (int)Math.ceil(Math.max(p1.x, Math.max(p2.x, Math.max(p3.x, p4.x))));
        int maxY = (int)Math.ceil(Math.max(p1.y, Math.max(p2.y, Math.max(p3.y, p4.y))));
        return new Rect2i(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }
}

