/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.lighting;

import org.lwjgl.opengl.GL11;
import org.zeith.hammerlib.api.lighting.ColoredLightManager;
import org.zeith.hammerlib.client.pipelines.shaders.ShaderVar;
import org.zeith.hammerlib.client.utils.GLHelperHL;

public class ShaderLightingVariable
extends ShaderVar {
    private int blockLimit;
    private final String lightStructName;

    public ShaderLightingVariable(String key) {
        this(key, "Light");
    }

    public ShaderLightingVariable(String key, String lightStructName) {
        super(key);
        this.lightStructName = lightStructName;
        GLHelperHL.glTaskAsync(() -> {
            this.blockLimit = GL11.glGetInteger((int)35376) / 8 / 4;
        });
    }

    @Override
    protected String getCurrentValue() {
        int i;
        int lightCount = ColoredLightManager.UNIFORM_LIGHT_COUNT.getAsInt();
        String layoutTemplate = "layout(std140) uniform lightBuffer%s\n{\n  " + this.lightStructName + " lights%s[2048];\n};\n\n";
        String methodHeader = this.lightStructName + " getLight(int idx)\n{";
        int blocks = (int)Math.ceil((float)lightCount / (float)this.blockLimit);
        StringBuilder gen = new StringBuilder();
        for (i = 0; i < blocks; ++i) {
            String s = Integer.toString(i);
            gen.append(String.format(layoutTemplate, s, s));
        }
        gen.append("\n" + methodHeader);
        for (i = 0; i < blocks; ++i) {
            int start = this.blockLimit * i;
            int end = Math.min(lightCount, this.blockLimit * (i + 1));
            gen.append("\n  " + (i > 0 ? "else " : "") + "if(idx >= " + start + " && idx < " + end + ") return lights" + i + "[idx - " + start + "];");
        }
        gen.append("\n  return lights0[0];");
        gen.append("\n}");
        return gen.toString();
    }
}

