/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.manager;

import com.mactso.spawnbalanceutility.config.MyConfig;
import com.mactso.spawnbalanceutility.util.Summary;
import com.mactso.spawnbalanceutility.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PsuedoMobManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Map<String, List<PsuedoMobItem>> PsuedoMobsMap = new HashMap<String, List<PsuedoMobItem>>();
    public static Hashtable<String, PsuedoMobItem> PsuedoMobHashtable = new Hashtable();
    static int lastgoodline = 0;
    private static int minBuildHeight = -64;
    private static int maxBuildHeight = 256;
    private static boolean firstTime = true;

    public static void psuedoMobInit() {
        int spawnWeight = 0;
        int minCount = 0;
        int maxCount = 0;
        int linecount = 0;
        int commentcount = 0;
        int blanklinecount = 0;
        int addcount = 0;
        String errorField = "first";
        if (PsuedoMobsMap.size() > 0) {
            return;
        }
        File f = new File("config/spawnbalanceutility/PsuedoMobs.csv");
        if (!f.exists()) {
            f = new File("config/spawnbalanceutility/PsuedoMobs.CSV");
        }
        try (InputStreamReader input = new InputStreamReader(new FileInputStream(f));){
            String line;
            BufferedReader br = new BufferedReader(input);
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    ++blanklinecount;
                    continue;
                }
                if (line.trim().isEmpty()) {
                    ++blanklinecount;
                    continue;
                }
                if (line.charAt(0) == '*') {
                    ++commentcount;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, ",");
                ++linecount;
                try {
                    int lineNumber;
                    errorField = "linenumber";
                    lastgoodline = lineNumber = Integer.parseInt(st.nextToken().trim());
                    errorField = "modAndBiome";
                    String modAndBiome = st.nextToken().trim();
                    errorField = "modAndMob";
                    String modAndMob = st.nextToken().trim();
                    errorField = "spawnWeight";
                    spawnWeight = Integer.parseInt(st.nextToken().trim());
                    errorField = "minCount";
                    minCount = Integer.parseInt(st.nextToken().trim());
                    errorField = "maxCount";
                    maxCount = Integer.parseInt(st.nextToken().trim());
                    if (minCount < 1) {
                        minCount = 1;
                    }
                    if (maxCount > 32) {
                        maxCount = 32;
                    }
                    if (minCount > maxCount) {
                        minCount = maxCount;
                    }
                    if (spawnWeight <= 0) continue;
                    LOGGER.info("SpawnBalanceUtility Processing PsuedoMob: " + line);
                    String key = modAndBiome;
                    PsuedoMobItem pmi = new PsuedoMobItem(lineNumber, modAndBiome, modAndMob, spawnWeight, minCount, maxCount);
                    Optional eot = EntityType.m_20632_((String)pmi.modAndMob);
                    if (eot.isPresent()) {
                        List<PsuedoMobItem> p = PsuedoMobsMap.get(key);
                        if (p == null) {
                            p = new ArrayList<PsuedoMobItem>();
                            PsuedoMobsMap.put(key, p);
                        }
                        p.add(pmi);
                        ++addcount;
                        continue;
                    }
                    LOGGER.info("Line:" + lineNumber + " PsuedoMob Configuration Error:" + pmi.modAndMob + " not registered with Minecraft.");
                }
                catch (Exception e) {
                    if (!line.isEmpty()) {
                        LOGGER.warn("SpawnBalanceUtility problem reading field " + errorField + " on " + linecount + "th line of PsuedoMobs.csv.");
                        continue;
                    }
                    if (MyConfig.getDebugLevel() <= 0) continue;
                    LOGGER.warn("SpawnBalanceUtility blank line at " + linecount + "th line of PsuedoMobs.csv.");
                }
            }
            input.close();
        }
        catch (Exception e) {
            LOGGER.warn("PsueodoMobs.csv not found in config/spawnbalanceutility/ (Remember you rename PsueodoMobs.rpt to create it). ");
            e.printStackTrace();
        }
        Summary.setBiomeReadInfo(linecount, linecount - addcount);
        Utility.debugMsg(0, commentcount + " comment lines in BiomeMobWeight.csv.");
        Utility.debugMsg(0, blanklinecount + " blank lines in BiomeMobWeight.csv.");
    }

    public static boolean checkSpawnPsuedoMob(ServerPlayer sp) {
        Utility.debugMsg(1, "PsuedoMob Spawn Attempt for " + sp.m_5446_().getString());
        if (PsuedoMobsMap.size() == 0) {
            return false;
        }
        BlockPos pos = sp.m_20183_();
        ServerLevel sLevel = sp.m_284548_();
        RandomSource rand = sLevel.m_213780_();
        int boxsize = 64;
        AABB box = AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)pos.m_6630_(boxsize).m_122013_(boxsize).m_122030_(boxsize), (Vec3i)pos.m_6625_(boxsize).m_122020_(boxsize).m_122025_(boxsize)));
        if (firstTime) {
            minBuildHeight = sLevel.m_141937_();
            maxBuildHeight = sLevel.m_151558_();
            firstTime = false;
        }
        int debug = 6;
        BlockPos.MutableBlockPos mSpawnPos = PsuedoMobManager.getRandomSolidSpawnPos(sp, box);
        if (mSpawnPos == null) {
            return false;
        }
        PsuedoMobItem pmi = PsuedoMobManager.getRandomPsuedoMob(sLevel, mSpawnPos, rand);
        int debug4 = 4;
        if (pmi == null) {
            return false;
        }
        Utility.debugMsg(2, pmi.modAndMob + " psuedo mob chosen");
        if (PsuedoMobManager.isPsuedoMobNearPlayer(sLevel, pmi, box)) {
            Utility.debugMsg(2, pmi.modAndMob + " is already near player " + sp.m_5446_().getString() + ".");
            return false;
        }
        Utility.debugMsg(2, pmi.modAndMob + " is not nearby player.");
        Optional eot = EntityType.m_20632_((String)pmi.modAndMob);
        if (eot.isEmpty()) {
            return false;
        }
        EntityType et = (EntityType)eot.get();
        if (PsuedoMobManager.isDarkEnoughToSpawnPsuedoMob(sLevel, et, mSpawnPos)) {
            Utility.debugMsg(2, pmi.modAndMob + " Light is valid.  Generating it.");
            return Utility.populateXEntityType(et, sp.m_284548_(), (BlockPos)mSpawnPos, pmi.maxCount, false);
        }
        Utility.debugMsg(2, pmi.modAndMob + " failed brightness spawn test (this has a random element).");
        return false;
    }

    private static boolean isDarkEnoughToSpawnPsuedoMob(ServerLevel sLevel, EntityType<?> et, BlockPos.MutableBlockPos mSpawnPos) {
        RandomSource rand = sLevel.m_213780_();
        int skylight = sLevel.m_45517_(LightLayer.SKY, (BlockPos)mSpawnPos);
        int blocklight = sLevel.m_45517_(LightLayer.BLOCK, (BlockPos)mSpawnPos);
        DimensionType dimensiontype = sLevel.m_6042_();
        int dimSpawnLight = dimensiontype.m_223570_();
        if (et.m_20615_((Level)sLevel) instanceof Monster) {
            if (blocklight < 1) {
                return true;
            }
            if (blocklight <= dimSpawnLight) {
                return true;
            }
            if (sLevel.m_46470_()) {
                skylight = Math.max(0, skylight - 6);
            }
            if (skylight > rand.m_188503_(16)) {
                Utility.debugMsg(2, "Too Bright for Monster Psuedo Spawn: " + blocklight);
                return false;
            }
        } else {
            if (blocklight > rand.m_188503_(6)) {
                return true;
            }
            Utility.debugMsg(2, "Too Dark for Non-Monster Psuedo Spawn: " + blocklight);
            return false;
        }
        return false;
    }

    private static PsuedoMobItem getRandomPsuedoMob(ServerLevel sLevel, BlockPos.MutableBlockPos mSpawnPos, RandomSource rand) {
        Holder biomeHolder = sLevel.m_204166_((BlockPos)mSpawnPos);
        Optional biomeKey = biomeHolder.m_203543_();
        if (biomeKey.isEmpty()) {
            return null;
        }
        String key = ((ResourceKey)biomeKey.get()).m_135782_().toString();
        List<PsuedoMobItem> p = PsuedoMobsMap.get(key);
        if (p == null) {
            Utility.debugMsg(2, "No Psuedo Mobs Configured for Biome " + key);
            return null;
        }
        Utility.debugMsg(2, "Randomly picking a Psuedo Mob for Biome " + key);
        int spawnTableTotalForBiome = 0;
        for (PsuedoMobItem pmTemp : p) {
            spawnTableTotalForBiome += pmTemp.spawnWeight;
        }
        int spawnRoll = rand.m_188503_(spawnTableTotalForBiome);
        int spawnweightvalue = 0;
        for (PsuedoMobItem pmTemp : p) {
            if (spawnRoll >= (spawnweightvalue += pmTemp.spawnWeight)) continue;
            return pmTemp;
        }
        return null;
    }

    private static BlockPos.MutableBlockPos getRandomSolidSpawnPos(ServerPlayer sp, AABB box) {
        ServerLevel sLevel = sp.m_284548_();
        RandomSource rand = sLevel.m_213780_();
        BlockPos pos = sp.m_20183_();
        int distAway = 24;
        int randDist = 32;
        int spX = distAway + rand.m_188503_(randDist);
        if (rand.m_188499_()) {
            spX *= -1;
        }
        int spY = rand.m_188503_(distAway + randDist);
        if (rand.m_188499_()) {
            spY *= -1;
        }
        spY = pos.m_123342_() + spY;
        spY = Math.max(minBuildHeight + 5, spY);
        spY = Math.min(maxBuildHeight - 5, spY);
        int spZ = distAway + rand.m_188503_(randDist);
        if (rand.m_188499_()) {
            spZ *= -1;
        }
        BlockPos.MutableBlockPos mSpawnPos = new BlockPos.MutableBlockPos((double)pos.m_123341_() + (double)spX, (double)spY, (double)pos.m_123343_() + (double)spZ);
        spY = sLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mSpawnPos).m_123342_();
        mSpawnPos.m_142448_(spY);
        int testcount = 0;
        while (!sp.m_284548_().m_8055_(mSpawnPos.m_7495_()).m_280296_()) {
            ++testcount;
            mSpawnPos.m_142448_(mSpawnPos.m_123342_() - 1);
            if (mSpawnPos.m_123342_() >= minBuildHeight + 5) continue;
            return null;
        }
        if (!box.m_82390_(mSpawnPos.m_252807_())) {
            return null;
        }
        if (sp.m_284548_().m_8055_(mSpawnPos.m_7495_()).m_280296_() && sp.m_284548_().m_8055_((BlockPos)mSpawnPos).m_60795_() && sp.m_284548_().m_8055_(mSpawnPos.m_6630_(1)).m_60795_()) {
            Utility.debugMsg(2, "Generate Random Spawn Pos " + mSpawnPos);
            return mSpawnPos;
        }
        Utility.debugMsg(2, "Psuedo Mob Random Spawn Position " + mSpawnPos + " was invalid.");
        return null;
    }

    private static boolean isPsuedoMobNearPlayer(ServerLevel sLevel, PsuedoMobItem pmi, AABB box) {
        Optional eot = EntityType.m_20632_((String)pmi.modAndMob);
        if (eot.isEmpty()) {
            return false;
        }
        EntityType et = (EntityType)eot.get();
        List elt = sLevel.m_142425_((EntityTypeTest)et, box, Entity::m_6084_);
        return !elt.isEmpty();
    }

    public static class PsuedoMobItem {
        int lineNumber;
        String modAndBiome;
        String classification;
        String modAndMob;
        int spawnWeight;
        int minCount;
        int maxCount;

        public PsuedoMobItem(int lineNumber, String modAndBiome, String modAndMob, int spawnWeight, int min, int max) {
            this.lineNumber = lineNumber;
            this.modAndBiome = modAndBiome;
            this.classification = this.classification;
            this.modAndMob = modAndMob;
            this.spawnWeight = spawnWeight;
            this.minCount = min;
            this.maxCount = max;
        }

        public String getModAndBiome() {
            return this.modAndBiome;
        }

        public String getClassification() {
            return this.classification;
        }

        public String getModAndMob() {
            return this.modAndMob;
        }

        public int getSpawnWeight() {
            return this.spawnWeight;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }
}

