/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.manager;

import com.mactso.spawnbalanceutility.config.MyConfig;
import com.mactso.spawnbalanceutility.util.Summary;
import com.mactso.spawnbalanceutility.util.Utility;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import net.minecraft.world.entity.MobCategory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobMassAdditionManager {
    public static Hashtable<String, MassAdditionMobItem> massAdditionMobsHashtable = new Hashtable();
    static int lastgoodline = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    public static String CATEGORY_ALL = "A";
    public static String CATEGORY_OVERWORLD = "O";
    public static String CATEGORY_NETHER = "N";
    public static String CATEGORY_THEEND = "E";

    public static List<MassAdditionMobItem> getFilteredList(MobCategory v, String category) {
        ArrayList<MassAdditionMobItem> ma = new ArrayList<MassAdditionMobItem>();
        for (MassAdditionMobItem m : massAdditionMobsHashtable.values()) {
            if (!v.m_21607_().equalsIgnoreCase(m.getClassification())) continue;
            if (m.getCategory().equals(CATEGORY_ALL)) {
                ma.add(m);
                continue;
            }
            if (category == Utility.NETHER) {
                if (!m.getCategory().equals(CATEGORY_NETHER)) continue;
                ma.add(m);
                continue;
            }
            if (category == Utility.THEEND) {
                if (!m.getCategory().equals(CATEGORY_THEEND)) continue;
                ma.add(m);
                continue;
            }
            if (category == Utility.NONE || !m.getCategory().equals(CATEGORY_OVERWORLD)) continue;
            ma.add(m);
        }
        return ma;
    }

    public static void massAdditionMobsInit() {
        int spawnWeight = 0;
        int minCount = 0;
        int maxCount = 0;
        int linecount = 0;
        int commentcount = 0;
        int blanklinecount = 0;
        String errorField = "first";
        if (massAdditionMobsHashtable.size() > 0) {
            return;
        }
        try (InputStreamReader input = new InputStreamReader(new FileInputStream("config/spawnbalanceutility/MassAdditionMobs.csv"));){
            String line;
            BufferedReader br = new BufferedReader(input);
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    ++blanklinecount;
                    continue;
                }
                if (line.trim().isEmpty()) {
                    ++blanklinecount;
                    continue;
                }
                if (line.charAt(0) == '*') {
                    ++commentcount;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, ",");
                ++linecount;
                try {
                    String token = st.nextToken().trim();
                    errorField = "linenumber";
                    lastgoodline = lineNumber = Integer.parseInt(token);
                    errorField = "category";
                    String category = st.nextToken().trim();
                    errorField = "classification";
                    String classification = st.nextToken().trim();
                    errorField = "modAndMob";
                    String modAndMob = st.nextToken().trim();
                    errorField = "spawnWeight";
                    spawnWeight = Integer.parseInt(st.nextToken().trim());
                    errorField = "minCount";
                    minCount = Integer.parseInt(st.nextToken().trim());
                    errorField = "maxCount";
                    maxCount = Integer.parseInt(st.nextToken().trim());
                    if (minCount < 1) {
                        minCount = 1;
                    }
                    if (maxCount > 32) {
                        maxCount = 32;
                    }
                    if (minCount > maxCount) {
                        minCount = maxCount;
                    }
                    String key = modAndMob;
                    if (!MobMassAdditionManager.validClassification(classification)) {
                        Utility.debugMsg(0, "spawnbalanceutility Invalid classification " + classification + " on " + linecount + "th line of MassAdditionMobs.csv.");
                        continue;
                    }
                    if (spawnWeight <= 0) continue;
                    MassAdditionMobItem bci = new MassAdditionMobItem(lineNumber, category, classification, modAndMob, spawnWeight, minCount, maxCount);
                    massAdditionMobsHashtable.put(key, bci);
                }
                catch (Exception e) {
                    if (!line.isEmpty()) {
                        LOGGER.warn("SpawnBalanceUtility Error reading field " + errorField + " on " + linecount + "th line of MassAdditionMobs.csv.");
                        continue;
                    }
                    if (MyConfig.getDebugLevel() <= 0) continue;
                    LOGGER.warn("SpawnBalanceUtility Warning blank line at " + linecount + "th line of MassAdditionMobs.csv.");
                }
            }
            input.close();
        }
        catch (Exception e) {
            LOGGER.info("SpawnBalanceUtility: Mass Addition Not Configured.  File config/spawnbalanceutility/MassAdditionMobs.csv not found.");
        }
        Summary.setMassAddReadInfo(linecount -= commentcount, linecount - massAdditionMobsHashtable.size());
        Utility.debugMsg(0, commentcount + " comment lines in MassAdditionMobs.csv.");
        Utility.debugMsg(0, blanklinecount + " blank lines in MassAdditionMobs.csv.");
    }

    public static boolean validClassification(String classification) {
        for (MobCategory e : MobCategory.values()) {
            if (!classification.equalsIgnoreCase(e.m_21607_())) continue;
            return true;
        }
        return false;
    }

    public static class MassAdditionMobItem {
        int lineNumber;
        String category;
        String classification;
        String modAndMob;
        int spawnWeight;
        int minCount;
        int maxCount;

        public MassAdditionMobItem(int lineNumber, String category, String classification, String modAndMob, int spawnWeight, int min, int max) {
            this.lineNumber = lineNumber;
            this.category = category;
            this.classification = classification;
            this.modAndMob = modAndMob;
            this.spawnWeight = spawnWeight;
            this.minCount = min;
            this.maxCount = max;
        }

        public String getCategory() {
            return this.category;
        }

        public String getClassification() {
            return this.classification;
        }

        public String getModAndMob() {
            return this.modAndMob;
        }

        public int getSpawnWeight() {
            return this.spawnWeight;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }
}

