/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.manager;

import com.mactso.spawnbalanceutility.config.MyConfig;
import com.mactso.spawnbalanceutility.util.Summary;
import com.mactso.spawnbalanceutility.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeCreatureManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Map<String, List<BiomeCreatureItem>> biomeCreaturesMap = new HashMap<String, List<BiomeCreatureItem>>();
    public static Hashtable<String, BiomeCreatureItem> biomeCreatureHashtable = new Hashtable();
    static int lastgoodline = 0;

    public static void biomeCreatureInit() {
        int spawnWeight = 0;
        int minCount = 0;
        int maxCount = 0;
        int linecount = 0;
        int commentcount = 0;
        int blanklinecount = 0;
        int addcount = 0;
        String errorField = "first";
        if (biomeCreaturesMap.size() > 0) {
            return;
        }
        File f = new File("config/spawnbalanceutility/BiomeMobWeight.csv");
        if (!f.exists()) {
            f = new File("config/spawnbalanceutility/BiomeMobWeight.CSV");
        }
        try (InputStreamReader input = new InputStreamReader(new FileInputStream(f));){
            String line;
            BufferedReader br = new BufferedReader(input);
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    ++blanklinecount;
                    continue;
                }
                if (line.trim().isEmpty()) {
                    ++blanklinecount;
                    continue;
                }
                if (line.charAt(0) == '*') {
                    ++commentcount;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, ",");
                ++linecount;
                try {
                    int lineNumber;
                    errorField = "linenumber";
                    lastgoodline = lineNumber = Integer.parseInt(st.nextToken().trim());
                    errorField = "category";
                    String category = st.nextToken().trim();
                    errorField = "modAndBiome";
                    String modAndBiome = st.nextToken().trim();
                    errorField = "classification";
                    String classification = st.nextToken().trim();
                    errorField = "modAndMob";
                    String modAndMob = st.nextToken().trim();
                    errorField = "spawnWeight";
                    spawnWeight = Integer.parseInt(st.nextToken().trim());
                    errorField = "minCount";
                    minCount = Integer.parseInt(st.nextToken().trim());
                    errorField = "maxCount";
                    maxCount = Integer.parseInt(st.nextToken().trim());
                    if (minCount < 1) {
                        minCount = 1;
                    }
                    if (maxCount > 32) {
                        maxCount = 32;
                    }
                    if (minCount > maxCount) {
                        minCount = maxCount;
                    }
                    String key = modAndBiome;
                    if (spawnWeight <= 0) continue;
                    BiomeCreatureItem bci = new BiomeCreatureItem(lineNumber, category, modAndBiome, classification, modAndMob, spawnWeight, minCount, maxCount);
                    List<BiomeCreatureItem> p = biomeCreaturesMap.get(key);
                    if (p == null) {
                        p = new ArrayList<BiomeCreatureItem>();
                        biomeCreaturesMap.put(key, p);
                    }
                    p.add(bci);
                    ++addcount;
                }
                catch (Exception e) {
                    if (!line.isEmpty()) {
                        LOGGER.warn("SpawnBalanceUtility problem reading field " + errorField + " on " + linecount + "th line of BiomeMobWeight.csv.");
                        continue;
                    }
                    if (MyConfig.getDebugLevel() <= 0) continue;
                    LOGGER.warn("SpawnBalanceUtility blank line at " + linecount + "th line of BiomeMobWeight.csv.");
                }
            }
            input.close();
        }
        catch (Exception e) {
            LOGGER.warn("BiomeMobWeight.csv not found in config/spawnbalanceutility/ (Remember you rename BiomeMobWeight.rpt to create it). ");
            e.printStackTrace();
        }
        Summary.setBiomeReadInfo(linecount, linecount - addcount);
        Utility.debugMsg(0, commentcount + " comment lines in BiomeMobWeight.csv.");
        Utility.debugMsg(0, blanklinecount + " blank lines in BiomeMobWeight.csv.");
    }

    public static class BiomeCreatureItem {
        int lineNumber;
        String category;
        String modAndBiome;
        String classification;
        String modAndMob;
        int spawnWeight;
        int minCount;
        int maxCount;

        public BiomeCreatureItem(int lineNumber, String category, String modAndBiome, String classification, String modAndMob, int spawnWeight, int min, int max) {
            this.lineNumber = lineNumber;
            this.category = category;
            this.modAndBiome = modAndBiome;
            this.classification = classification;
            this.modAndMob = modAndMob;
            this.spawnWeight = spawnWeight;
            this.minCount = min;
            this.maxCount = max;
        }

        public String getCategory() {
            return this.category;
        }

        public String getModAndBiome() {
            return this.modAndBiome;
        }

        public String getClassification() {
            return this.classification;
        }

        public String getModAndMob() {
            return this.modAndMob;
        }

        public int getSpawnWeight() {
            return this.spawnWeight;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }
}

