/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.abnormal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamabnormals.blueprint.common.block.BlueprintBeehiveBlock;
import com.teamabnormals.blueprint.common.block.LeafPileBlock;
import com.teamabnormals.blueprint.core.registry.BlueprintBlockEntityTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestItem;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class WoodworksModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> bookshelves;
    public final SimpleEntrySet<WoodType, Block> chiseled_bookshelves;
    public final SimpleEntrySet<WoodType, Block> boards;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> beehives;
    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;
    public final SimpleEntrySet<LeavesType, Block> leafPiles;

    public WoodworksModule(String modId) {
        super(modId, "abnww");
        ResourceKey tab = CreativeModeTabs.f_256788_;
        this.bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf", this.getModBlock("acacia_bookshelf"), () -> VanillaWoodTypes.ACACIA, woodType -> new Block(Utils.copyPropertySafe((Block)woodType.log).m_60978_(1.5f))).addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_278384_, Registries.f_256747_)).addTag(Tags.Blocks.BOOKSHELVES, Registries.f_256747_)).addTag(new ResourceLocation("blueprint:wooden_bookshelves"), new ResourceKey[]{Registries.f_256747_, Registries.f_256913_})).addTag(Tags.Items.BOOKSHELVES, Registries.f_256913_)).setTabKey(tab)).defaultRecipe().copyParentDrop().build();
        this.addEntry(this.bookshelves);
        this.chiseled_bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf", "chiseled", this.getModBlock("chiseled_acacia_bookshelf"), () -> VanillaWoodTypes.ACACIA, woodType -> new ChiseledBookShelfBlock(Utils.copyPropertySafe((Block)woodType.log).m_60978_(1.5f))).addTexture(this.modRes("block/chiseled_acacia_bookshelf_empty"))).addTextureM(this.modRes("block/chiseled_acacia_bookshelf_occupied"), EveryCompat.res("block/acacia_chiseled_bookshelf_occupied_m"))).addTexture(this.modRes("block/chiseled_acacia_bookshelf_side"))).addTexture(this.modRes("block/chiseled_acacia_bookshelf_top"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(new ResourceLocation("blueprint:wooden_chiseled_bookshelves"), Registries.f_256747_)).addTag(new ResourceLocation("blueprint:wooden_chiseled_bookshelves"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().copyParentDrop().build();
        this.addEntry(this.chiseled_bookshelves);
        this.boards = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "boards", WoodworksBlocks.OAK_BOARDS, () -> VanillaWoodTypes.OAK, woodType -> new RotatedPillarBlock(Utils.copyPropertySafe((Block)woodType.planks).m_60913_(2.0f, 3.0f))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("wooden_boards"), Registries.f_256747_)).addTag(this.modRes("wooden_boards"), Registries.f_256913_)).addTexture(this.modRes("block/oak_boards"))).setTabKey(tab)).defaultRecipe().copyParentDrop().build();
        this.addEntry(this.boards);
        this.ladders = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "ladder", this.getModBlock("spruce_ladder"), () -> VanillaWoodTypes.SPRUCE, woodType -> new LadderBlock(Utils.copyPropertySafe((Block)Blocks.f_50155_).m_60978_(0.4f).m_60955_().m_278166_(PushReaction.DESTROY))).setRenderType(RenderLayer.CUTOUT_MIPPED).addTexture(EveryCompat.res("block/spruce_ladder"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_201924_, Registries.f_256747_)).addTag(BlockTags.f_13082_, Registries.f_256747_)).addTag(new ResourceLocation("forge:ladders"), Registries.f_256747_)).addTag(new ResourceLocation("blueprint:wooden_ladders"), Registries.f_256747_)).addTag(new ResourceLocation("quark:ladders"), Registries.f_256747_)).addTag(new ResourceLocation("forge:ladders"), Registries.f_256913_)).addTag(new ResourceLocation("blueprint:wooden_ladders"), Registries.f_256913_)).addTag(new ResourceLocation("quark:ladders"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.ladders);
        this.beehives = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "beehive", this.getModBlock("spruce_beehive"), () -> VanillaWoodTypes.SPRUCE, woodType -> new BlueprintBeehiveBlock(Utils.copyPropertySafe((Block)woodType.log).m_60978_(0.6f))).addTile(BlueprintBlockEntityTypes.BEEHIVE).addTextureM(EveryCompat.res("block/spruce_beehive_front_honey"), EveryCompat.res("block/spruce_beehive_front_honey_m"))).addTextureM(EveryCompat.res("block/spruce_beehive_front"), EveryCompat.res("block/spruce_beehive_front_m"))).addTextureM(EveryCompat.res("block/spruce_beehive_side"), EveryCompat.res("block/spruce_beehive_side_m"))).addTexture(EveryCompat.res("block/spruce_beehive_end"))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13072_, Registries.f_256747_)).addTag(new ResourceLocation("blueprint:wooden_beehives"), new ResourceKey[]{Registries.f_256747_, Registries.f_256913_})).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.beehives);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", this.getModBlock("oak_chest"), () -> VanillaWoodTypes.OAK, woodType -> new CompatChestBlock(this::getChestTile, Utils.copyPropertySafe((Block)woodType.planks).m_60978_(2.5f))).setTabKey(tab)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13088_, Registries.f_256747_)).addTag(Tags.Blocks.CHESTS, Registries.f_256747_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registries.f_256747_)).addTag(Tags.Items.CHESTS, Registries.f_256913_)).addTag(Tags.Items.CHESTS_WOODEN, Registries.f_256913_)).addTag(new ResourceLocation("blueprint:wooden_chests"), new ResourceKey[]{Registries.f_256913_, Registries.f_256747_})).addTag(new ResourceLocation("quark", "revertable_chests"), Registries.f_256913_)).addTag(new ResourceLocation("quark", "boatable_chests"), Registries.f_256913_)).addTile((x$0, x$1) -> new abwwChestBlockEntity((BlockPos)x$0, (BlockState)x$1)).addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).defaultRecipe().build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", "trapped", this.getModBlock("trapped_oak_chest"), () -> VanillaWoodTypes.OAK, woodType -> new CompatTrappedChestBlock(this::getTrappedTile, Utils.copyPropertySafe((Block)woodType.planks).m_60978_(2.5f))).setTabKey(tab)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13088_, Registries.f_256747_)).addTag(Tags.Blocks.CHESTS, Registries.f_256747_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registries.f_256747_)).addTag(Tags.Blocks.CHESTS_TRAPPED, Registries.f_256747_)).addTag(new ResourceLocation("blueprint:wooden_trapped_chests"), Registries.f_256747_)).addTag(Tags.Items.CHESTS, Registries.f_256913_)).addTag(Tags.Items.CHESTS_WOODEN, Registries.f_256913_)).addTag(Tags.Items.CHESTS_TRAPPED, Registries.f_256913_)).addTag(new ResourceLocation("blueprint:wooden_trapped_chests"), Registries.f_256913_)).addTile((x$0, x$1) -> new abwwTrappedBlockEntity((BlockPos)x$0, (BlockState)x$1)).addCustomItem((w, block, properties) -> new CompatChestItem((Block)block, (Item.Properties)properties)).defaultRecipe().build();
        this.addEntry(this.trappedChests);
        this.leafPiles = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(LeavesType.class, "leaf_pile", WoodworksBlocks.OAK_LEAF_PILE, () -> VanillaLeavesTypes.OAK, leavesType -> {
            if (leavesType.getWoodType() == null) {
                return null;
            }
            return new LeafPileBlock(Utils.copyPropertySafe((Block)leavesType.leaves).m_60978_(0.2f).m_278183_().m_278166_(PushReaction.DESTROY));
        }).setRenderType(RenderLayer.CUTOUT_MIPPED).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))).addTag(BlockTags.f_144281_, Registries.f_256747_)).addTag(this.modRes("leaf_piles"), new ResourceKey[]{Registries.f_256747_, Registries.f_256913_})).setTabKey(tab)).defaultRecipe().copyParentDrop().copyParentTint()).build();
        this.addEntry(this.leafPiles);
    }

    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return this.trappedChests.getTile(CompatChestBlockEntity.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
        CompatChestBlockRenderer.register(event, this.trappedChests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> this.bookshelves.items.forEach((wood, item) -> {
            Item getLadder = (Item)this.ladders.items.get(wood);
            Item ladder = getLadder != null ? getLadder : (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.fromNamespaceAndPath((String)wood.getNamespace(), (String)(wood.getTypeName() + "_ladder")));
            this.sawmillRecipe("oak_planks_from_oak_logs_sawing", wood.log.m_5456_(), wood.planks.m_5456_(), sink, manager, (WoodType)wood);
            this.sawmillRecipe("oak_boards_from_oak_logs_sawing", wood.log.m_5456_(), (Item)this.boards.items.get(wood), sink, manager, (WoodType)wood);
            this.sawmillRecipe("spruce_ladder_from_spruce_logs_sawing", wood.log.m_5456_(), ladder, sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_button_from_oak_logs_sawing", true, "button", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_door_from_oak_logs_sawing", true, "door", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_fence_from_oak_logs_sawing", true, "fence", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_fence_gate_from_oak_logs_sawing", true, "fence_gate", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_pressure_plate_from_oak_logs_sawing", true, "pressure_plate", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_sign_from_oak_logs_sawing", true, "sign", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_slab_from_oak_logs_sawing", true, "slab", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_stairs_from_oak_logs_sawing", true, "stairs", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_trapdoor_from_oak_logs_sawing", true, "trapdoor", sink, manager, (WoodType)wood);
            this.sawmillRecipe("oak_boards_from_oak_planks_sawing", wood.planks.m_5456_(), (Item)this.boards.items.get(wood), sink, manager, (WoodType)wood);
            this.sawmillRecipe("spruce_ladder_from_spruce_planks_sawing", wood.planks.m_5456_(), ladder, sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_button_from_oak_planks_sawing", false, "button", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_fence_from_oak_planks_sawing", false, "fence", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_slab_from_oak_planks_sawing", false, "slab", sink, manager, (WoodType)wood);
            this.createRecipeIfNotNull("oak_stairs_from_oak_planks_sawing", false, "stairs", sink, manager, (WoodType)wood);
        }));
    }

    public void createRecipeIfNotNull(String recipeName, boolean usingLog, String output, ResourceSink sink, ResourceManager manager, WoodType wood) {
        Item input;
        Item item = input = usingLog ? wood.log.m_5456_() : wood.planks.m_5456_();
        if (Objects.nonNull(wood.getItemOfThis(output))) {
            this.sawmillRecipe(recipeName, input, wood.getItemOfThis(output), sink, manager, wood);
        } else if (Objects.nonNull(wood.getBlockOfThis(output))) {
            this.sawmillRecipe(recipeName, input, wood.getBlockOfThis(output).m_5456_(), sink, manager, wood);
        }
    }

    public void sawmillRecipe(String recipeName, Item input, Item output, ResourceSink sink, ResourceManager manager, WoodType wood) {
        ResourceLocation recipeLocation = this.modRes("recipes/" + recipeName + ".json");
        try (InputStream recipeStream = ((Resource)manager.m_213713_(recipeLocation).orElseThrow(() -> new FileNotFoundException("File Not Found: " + recipeLocation))).m_215507_();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            JsonObject foundRecipe = recipe.getAsJsonArray("recipes").get(0).getAsJsonObject().getAsJsonObject("recipe");
            JsonObject getIngredient = foundRecipe.getAsJsonObject("ingredient");
            if (getIngredient.has("tag")) {
                getIngredient.addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", (BlockType)wood, sink, manager).toString());
            } else {
                getIngredient.addProperty("item", Utils.getID((Item)input).toString());
            }
            foundRecipe.addProperty("result", Utils.getID((Item)output).toString());
            String[] nameSplit = recipeName.split("_(?!gate|plate)");
            String filenameBuilder = "_" + nameSplit[1] + "_from_" + wood.getTypeName() + "_" + nameSplit[4] + "_sawing";
            sink.addJson(EveryCompat.res(this.shortenedId() + "/" + wood.getAppendableId() + filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Error while creating recipes for woodwork sawmill: ", (Throwable)e);
        }
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> this.trappedChests.blocks.forEach((wood, block) -> {
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak/normal"), EveryCompat.res("model/oak_chest_normal_m"), EveryCompat.res("model/oak_chest_normal_o"), EveryCompat.res("model/trapped_chest_normal"));
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak/normal_left"), EveryCompat.res("model/oak_chest_left_m"), EveryCompat.res("model/oak_chest_left_o"), EveryCompat.res("model/trapped_chest_left"));
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak/normal_right"), EveryCompat.res("model/oak_chest_right_m"), EveryCompat.res("model/oak_chest_right_o"), EveryCompat.res("model/trapped_chest_right"));
        }));
    }

    private class abwwTrappedBlockEntity
    extends CompatChestBlockEntity {
        public abwwTrappedBlockEntity(BlockPos pos, BlockState state) {
            super(WoodworksModule.this.trappedChests.getTile(), pos, state);
        }
    }

    private class abwwChestBlockEntity
    extends CompatChestBlockEntity {
        public abwwChestBlockEntity(BlockPos pos, BlockState state) {
            super(WoodworksModule.this.chests.getTile(), pos, state);
        }
    }
}

