/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.ItemPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.EnchantmentPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ItemPredicateParser {
    public static Component parseItemPredicate(ItemPredicate predicate) {
        EnchantmentPredicate[] storedEnchants;
        TagKey<Item> tag = ((ItemPredicateAccessor)predicate).getTag();
        if (tag != null) {
            return LText.translatable("emi_loot.item_predicate.tag", tag.f_203868_());
        }
        Set<Item> items = ((ItemPredicateAccessor)predicate).getItems();
        if (items != null && !items.isEmpty()) {
            List<MutableComponent> list = items.stream().map(item -> (MutableComponent)item.m_41466_()).toList();
            return LText.translatable("emi_loot.item_predicate.items", ListProcessors.buildOrList(list));
        }
        MinMaxBounds.Ints count = ((ItemPredicateAccessor)predicate).getCount();
        if (count != MinMaxBounds.Ints.f_55364_) {
            Integer max = (Integer)count.m_55326_();
            Integer min = (Integer)count.m_55305_();
            int finalMax = max != null ? max : 0;
            int finalMin = min != null ? min : 0;
            return LText.translatable("emi_loot.item_predicate.count", Integer.toString(finalMin), Integer.toString(finalMax));
        }
        MinMaxBounds.Ints durability = ((ItemPredicateAccessor)predicate).getDurability();
        if (durability != MinMaxBounds.Ints.f_55364_) {
            Integer max = (Integer)durability.m_55326_();
            Integer min = (Integer)durability.m_55305_();
            int finalMax = max != null ? max : 0;
            int finalMin = min != null ? min : 0;
            return LText.translatable("emi_loot.item_predicate.durability", Integer.toString(finalMin), Integer.toString(finalMax));
        }
        EnchantmentPredicate[] enchants = ((ItemPredicateAccessor)predicate).getEnchantments();
        if (enchants.length + (storedEnchants = ((ItemPredicateAccessor)predicate).getStoredEnchantments()).length > 0) {
            ArrayList<EnchantmentPredicate> list = new ArrayList<EnchantmentPredicate>();
            list.addAll(Arrays.stream(enchants).toList());
            list.addAll(Arrays.stream(storedEnchants).toList());
            return EnchantmentPredicateParser.parseEnchantmentPredicates(list);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty item predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

