/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.util.villager.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MinerVillagerScreen
extends AbstractContainerScreen<MerchantMenu> {
    private static final ResourceLocation CUSTOM_MINER_VILLAGER_GUI_TEXTURE = new ResourceLocation("minervillager", "textures/gui/miner_villager.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int MERCHANT_MENU_PART_X = 99;
    private static final int PROGRESS_BAR_X = 136;
    private static final int PROGRESS_BAR_Y = 16;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 7;
    private static final int TRADE_BUTTON_X = 5;
    private static final int TRADE_BUTTON_HEIGHT = 20;
    private static final int TRADE_BUTTON_WIDTH = 88;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 139;
    private static final int SCROLL_BAR_TOP_POS_Y = 18;
    private static final int SCROLL_BAR_START_X = 94;
    private static final Component TRADES_LABEL = Component.m_237115_((String)"merchant.trades");
    private static final Component LEVEL_SEPARATOR = Component.m_237113_((String)" - ");
    private static final Component DEPRECATED_TOOLTIP = Component.m_237115_((String)"merchant.deprecated");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[7];
    int scrollOff;
    private boolean isDragging;

    public MinerVillagerScreen(MerchantMenu p_99123_, Inventory p_99124_, Component p_99125_) {
        super((AbstractContainerMenu)p_99123_, p_99124_, p_99125_);
        this.f_97726_ = 276;
        this.f_97730_ = 107;
    }

    private void postButtonClick() {
        ((MerchantMenu)this.f_97732_).m_40063_(this.shopItem);
        ((MerchantMenu)this.f_97732_).m_40072_(this.shopItem);
        this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundSelectTradePacket(this.shopItem));
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int k = j + 16 + 2;
        for (int l = 0; l < 7; ++l) {
            this.tradeOfferButtons[l] = (TradeOfferButton)this.m_142416_((GuiEventListener)new TradeOfferButton(i + 5, k, l, p_99174_ -> {
                if (p_99174_ instanceof TradeOfferButton) {
                    this.shopItem = ((TradeOfferButton)p_99174_).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            k += 20;
        }
    }

    protected void m_280003_(GuiGraphics p_283337_, int p_282009_, int p_283691_) {
        int i = ((MerchantMenu)this.f_97732_).m_40071_();
        if (i > 0 && i <= 5 && ((MerchantMenu)this.f_97732_).m_40076_()) {
            MutableComponent component = this.f_96539_.m_6881_().m_7220_(LEVEL_SEPARATOR).m_7220_((Component)Component.m_237115_((String)("merchant.level." + i)));
            int j = this.f_96547_.m_92852_((FormattedText)component);
            int k = 49 + this.f_97726_ / 2 - j / 2;
            p_283337_.m_280614_(this.f_96547_, (Component)component, k, 6, 0x404040, false);
        } else {
            p_283337_.m_280614_(this.f_96547_, this.f_96539_, 49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, 0x404040, false);
        }
        p_283337_.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        int l = this.f_96547_.m_92852_((FormattedText)TRADES_LABEL);
        p_283337_.m_280614_(this.f_96547_, TRADES_LABEL, 5 - l / 2 + 48, 6, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics p_283072_, float p_281275_, int p_282312_, int p_282984_) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        p_283072_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, i, j, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        MerchantOffers merchantoffers = ((MerchantMenu)this.f_97732_).m_40075_();
        if (!merchantoffers.isEmpty()) {
            int k = this.shopItem;
            if (k < 0 || k >= merchantoffers.size()) {
                return;
            }
            MerchantOffer merchantoffer = (MerchantOffer)merchantoffers.get(k);
            if (merchantoffer.m_45380_()) {
                p_283072_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, this.f_97735_ + 83 + 99, this.f_97736_ + 35, 0, 311.0f, 0.0f, 28, 21, 512, 256);
            }
        }
    }

    private void renderProgressBar(GuiGraphics p_281426_, int p_283008_, int p_283085_, MerchantOffer p_282094_) {
        int i = ((MerchantMenu)this.f_97732_).m_40071_();
        int j = ((MerchantMenu)this.f_97732_).m_40065_();
        if (i < 5) {
            p_281426_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_283008_ + 136, p_283085_ + 16, 0, 0.0f, 186.0f, 102, 5, 512, 256);
            int k = VillagerData.m_35572_((int)i);
            if (j >= k && VillagerData.m_35582_((int)i)) {
                int l = 100;
                float f = 100.0f / (float)(VillagerData.m_35577_((int)i) - k);
                int i1 = Math.min(Mth.m_14143_((float)(f * (float)(j - k))), 100);
                p_281426_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_283008_ + 136, p_283085_ + 16, 0, 0.0f, 191.0f, i1 + 1, 5, 512, 256);
                int j1 = ((MerchantMenu)this.f_97732_).m_40068_();
                if (j1 > 0) {
                    int k1 = Math.min(Mth.m_14143_((float)((float)j1 * f)), 100 - i1);
                    p_281426_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_283008_ + 136 + i1 + 1, p_283085_ + 16 + 1, 0, 2.0f, 182.0f, k1, 3, 512, 256);
                }
            }
        }
    }

    private void renderScroller(GuiGraphics p_283030_, int p_283154_, int p_281664_, MerchantOffers p_282877_) {
        int i = p_282877_.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int l = 113;
            int i1 = Math.min(113, this.scrollOff * k);
            if (this.scrollOff == i - 1) {
                i1 = 113;
            }
            p_283030_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_283154_ + 94, p_281664_ + 18 + i1, 0, 0.0f, 199.0f, 6, 27, 512, 256);
        } else {
            p_283030_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_283154_ + 94, p_281664_ + 18, 0, 6.0f, 199.0f, 6, 27, 512, 256);
        }
    }

    public void m_88315_(GuiGraphics p_283487_, int p_281994_, int p_282099_, float p_281815_) {
        this.m_280273_(p_283487_);
        super.m_88315_(p_283487_, p_281994_, p_282099_, p_281815_);
        MerchantOffers merchantoffers = ((MerchantMenu)this.f_97732_).m_40075_();
        if (!merchantoffers.isEmpty()) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            int k = j + 16 + 1;
            int l = i + 5 + 5;
            this.renderScroller(p_283487_, i, j, merchantoffers);
            int i1 = 0;
            for (MerchantOffer merchantoffer : merchantoffers) {
                if (!this.canScroll(merchantoffers.size()) || i1 >= this.scrollOff && i1 < 7 + this.scrollOff) {
                    ItemStack itemstack = merchantoffer.m_45352_();
                    ItemStack itemstack1 = merchantoffer.m_45358_();
                    ItemStack itemstack2 = merchantoffer.m_45364_();
                    ItemStack itemstack3 = merchantoffer.m_45368_();
                    p_283487_.m_280168_().m_85836_();
                    p_283487_.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                    int j1 = k + 2;
                    this.renderAndDecorateCostA(p_283487_, itemstack1, itemstack, l, j1);
                    if (!itemstack2.m_41619_()) {
                        p_283487_.m_280203_(itemstack2, i + 5 + 35, j1);
                        p_283487_.m_280370_(this.f_96547_, itemstack2, i + 5 + 35, j1);
                    }
                    this.renderButtonArrows(p_283487_, merchantoffer, i, j1);
                    p_283487_.m_280203_(itemstack3, i + 5 + 68, j1);
                    p_283487_.m_280370_(this.f_96547_, itemstack3, i + 5 + 68, j1);
                    p_283487_.m_280168_().m_85849_();
                    k += 20;
                    ++i1;
                    continue;
                }
                ++i1;
            }
            int k1 = this.shopItem;
            MerchantOffer merchantoffer1 = (MerchantOffer)merchantoffers.get(k1);
            if (((MerchantMenu)this.f_97732_).m_40076_()) {
                this.renderProgressBar(p_283487_, i, j, merchantoffer1);
            }
            if (merchantoffer1.m_45380_() && this.m_6774_(186, 35, 22, 21, p_281994_, p_282099_) && ((MerchantMenu)this.f_97732_).m_40074_()) {
                p_283487_.m_280557_(this.f_96547_, DEPRECATED_TOOLTIP, p_281994_, p_282099_);
            }
            for (TradeOfferButton merchantscreen$tradeofferbutton : this.tradeOfferButtons) {
                if (merchantscreen$tradeofferbutton.m_198029_()) {
                    merchantscreen$tradeofferbutton.renderToolTip(p_283487_, p_281994_, p_282099_);
                }
                merchantscreen$tradeofferbutton.f_93624_ = merchantscreen$tradeofferbutton.index < ((MerchantMenu)this.f_97732_).m_40075_().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.m_280072_(p_283487_, p_281994_, p_282099_);
    }

    private void renderButtonArrows(GuiGraphics p_283020_, MerchantOffer p_281926_, int p_282752_, int p_282179_) {
        RenderSystem.enableBlend();
        if (p_281926_.m_45380_()) {
            p_283020_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_282752_ + 5 + 35 + 20, p_282179_ + 3, 0, 25.0f, 171.0f, 10, 9, 512, 256);
        } else {
            p_283020_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_282752_ + 5 + 35 + 20, p_282179_ + 3, 0, 15.0f, 171.0f, 10, 9, 512, 256);
        }
    }

    private void renderAndDecorateCostA(GuiGraphics p_281357_, ItemStack p_283466_, ItemStack p_282046_, int p_282403_, int p_283601_) {
        p_281357_.m_280203_(p_283466_, p_282403_, p_283601_);
        if (p_282046_.m_41613_() == p_283466_.m_41613_()) {
            p_281357_.m_280370_(this.f_96547_, p_283466_, p_282403_, p_283601_);
        } else {
            p_281357_.m_280302_(this.f_96547_, p_282046_, p_282403_, p_283601_, p_282046_.m_41613_() == 1 ? "1" : null);
            p_281357_.m_280168_().m_85836_();
            p_281357_.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            String count = p_283466_.m_41613_() == 1 ? "1" : String.valueOf(p_283466_.m_41613_());
            this.f_96547_.m_272078_(count, (float)(p_282403_ + 14) + 19.0f - 2.0f - (float)this.f_96547_.m_92895_(count), (float)p_283601_ + 6.0f + 3.0f, 0xFFFFFF, true, p_281357_.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)p_281357_.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
            p_281357_.m_280168_().m_85849_();
            p_281357_.m_280168_().m_85836_();
            p_281357_.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            p_281357_.m_280398_(CUSTOM_MINER_VILLAGER_GUI_TEXTURE, p_282403_ + 7, p_283601_ + 12, 0, 0.0f, 176.0f, 9, 2, 512, 256);
            p_281357_.m_280168_().m_85849_();
        }
    }

    private boolean canScroll(int p_99141_) {
        return p_99141_ > 7;
    }

    public boolean m_6050_(double p_99127_, double p_99128_, double p_99129_) {
        int i = ((MerchantMenu)this.f_97732_).m_40075_().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - p_99129_)), (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double p_99135_, double p_99136_, int p_99137_, double p_99138_, double p_99139_) {
        int i = ((MerchantMenu)this.f_97732_).m_40075_().size();
        if (this.isDragging) {
            int j = this.f_97736_ + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)p_99136_ - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.m_7979_(p_99135_, p_99136_, p_99137_, p_99138_, p_99139_);
    }

    public boolean m_6375_(double p_99131_, double p_99132_, int p_99133_) {
        this.isDragging = false;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((MerchantMenu)this.f_97732_).m_40075_().size()) && p_99131_ > (double)(i + 94) && p_99131_ < (double)(i + 94 + 6) && p_99132_ > (double)(j + 18) && p_99132_ <= (double)(j + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(p_99131_, p_99132_, p_99133_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class TradeOfferButton
    extends Button {
        final int index;

        public TradeOfferButton(int p_99205_, int p_99206_, int p_99207_, Button.OnPress p_99208_) {
            super(p_99205_, p_99206_, 88, 20, CommonComponents.f_237098_, p_99208_, f_252438_);
            this.index = p_99207_;
            this.f_93624_ = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics p_281313_, int p_283342_, int p_283060_) {
            if (this.f_93622_ && ((MerchantMenu)MinerVillagerScreen.this.f_97732_).m_40075_().size() > this.index + MinerVillagerScreen.this.scrollOff) {
                if (p_283342_ < this.m_252754_() + 20) {
                    ItemStack itemstack = ((MerchantOffer)((MerchantMenu)MinerVillagerScreen.this.f_97732_).m_40075_().get(this.index + MinerVillagerScreen.this.scrollOff)).m_45358_();
                    p_281313_.m_280153_(MinerVillagerScreen.this.f_96547_, itemstack, p_283342_, p_283060_);
                } else if (p_283342_ < this.m_252754_() + 50 && p_283342_ > this.m_252754_() + 30) {
                    ItemStack itemstack2 = ((MerchantOffer)((MerchantMenu)MinerVillagerScreen.this.f_97732_).m_40075_().get(this.index + MinerVillagerScreen.this.scrollOff)).m_45364_();
                    if (!itemstack2.m_41619_()) {
                        p_281313_.m_280153_(MinerVillagerScreen.this.f_96547_, itemstack2, p_283342_, p_283060_);
                    }
                } else if (p_283342_ > this.m_252754_() + 65) {
                    ItemStack itemstack1 = ((MerchantOffer)((MerchantMenu)MinerVillagerScreen.this.f_97732_).m_40075_().get(this.index + MinerVillagerScreen.this.scrollOff)).m_45368_();
                    p_281313_.m_280153_(MinerVillagerScreen.this.f_96547_, itemstack1, p_283342_, p_283060_);
                }
            }
        }
    }
}

