/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.recipe;

import com.eruannie_9.minervillager.recipe.EmeraldAnvilRecipe;
import com.eruannie_9.minervillager.util.RecipeCategory;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class EmeraldAnvilRecipeSerializer
implements RecipeSerializer<EmeraldAnvilRecipe> {
    public static final EmeraldAnvilRecipeSerializer INSTANCE = new EmeraldAnvilRecipeSerializer();
    public static final ResourceLocation ID = new ResourceLocation("minervillager", "emerald_anvil");

    @NotNull
    public EmeraldAnvilRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        NonNullList ingredients = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
        RecipeCategory category = RecipeCategory.valueOf(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"REPAIR"));
        int repairAmount = 0;
        ItemStack result = ItemStack.f_41583_;
        switch (category) {
            case REPAIR: {
                ingredients.set(0, (Object)this.getIngredientFromJson(json.get("damaged_item")));
                ingredients.set(1, (Object)this.getIngredientFromJson(json.get("repair_material")));
                repairAmount = GsonHelper.m_13824_((JsonObject)json, (String)"repair_amount", (int)0);
                break;
            }
            case COMBINE: {
                ingredients.set(0, (Object)this.getIngredientFromJson(json.get("slot_1")));
                ingredients.set(1, (Object)this.getIngredientFromJson(json.get("slot_2")));
                result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            }
        }
        return new EmeraldAnvilRecipe(recipeId, (NonNullList<Ingredient>)ingredients, result, category, repairAmount);
    }

    private Ingredient getIngredientFromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("item")) {
                return Ingredient.m_43917_((JsonElement)jsonObject);
            }
            if (jsonObject.has("tag")) {
                ResourceLocation tagId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
                TagKey tagKey = ItemTags.create((ResourceLocation)tagId);
                return Ingredient.m_204132_((TagKey)tagKey);
            }
        }
        throw new IllegalArgumentException("Invalid ingredient format");
    }

    public EmeraldAnvilRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        NonNullList ingredients = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
        ingredients.set(0, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        ingredients.set(1, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        RecipeCategory category = (RecipeCategory)buffer.m_130066_(RecipeCategory.class);
        int repairAmount = 0;
        ItemStack result = ItemStack.f_41583_;
        if (category == RecipeCategory.REPAIR) {
            repairAmount = buffer.readInt();
        } else if (category == RecipeCategory.COMBINE) {
            result = buffer.m_130267_();
        }
        return new EmeraldAnvilRecipe(recipeId, (NonNullList<Ingredient>)ingredients, result, category, repairAmount);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, EmeraldAnvilRecipe recipe) {
        ((Ingredient)recipe.m_7527_().get(0)).m_43923_(buffer);
        ((Ingredient)recipe.m_7527_().get(1)).m_43923_(buffer);
        buffer.m_130068_((Enum)recipe.getCategory());
        if (recipe.getCategory() == RecipeCategory.REPAIR) {
            buffer.writeInt(recipe.getRepairAmount());
        } else if (recipe.getCategory() == RecipeCategory.COMBINE) {
            buffer.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }
    }
}

