/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.recipe;

import com.eruannie_9.minervillager.recipe.ModRecipes;
import com.eruannie_9.minervillager.util.RecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class EmeraldAnvilRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final RecipeCategory category;
    private final int repairAmount;

    public EmeraldAnvilRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result, RecipeCategory category, int repairAmount) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        this.category = category;
        this.repairAmount = repairAmount;
    }

    public boolean m_5818_(Container inv, Level world) {
        ItemStack inputItem = inv.m_8020_(0);
        ItemStack materialItem = inv.m_8020_(1);
        switch (this.category) {
            case REPAIR: {
                if (inputItem.m_41619_() || !inputItem.m_41768_() || materialItem.m_41619_()) {
                    return false;
                }
                return ((Ingredient)this.ingredients.get(0)).test(inputItem) && ((Ingredient)this.ingredients.get(1)).test(materialItem);
            }
            case COMBINE: {
                return ((Ingredient)this.ingredients.get(0)).test(inputItem) && ((Ingredient)this.ingredients.get(1)).test(materialItem);
            }
        }
        return false;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        ItemStack inputItem = inv.m_8020_(0).m_41777_();
        ItemStack materialItem = inv.m_8020_(1).m_41777_();
        switch (this.category) {
            case REPAIR: {
                int damageValue = inputItem.m_41773_();
                int itemsAvailable = materialItem.m_41613_();
                int totalRepairAmount = itemsAvailable * this.repairAmount;
                int repairAmountToApply = Math.min(damageValue, totalRepairAmount);
                inputItem.m_41721_(damageValue - repairAmountToApply);
                return inputItem;
            }
            case COMBINE: {
                return this.result.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registry) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.EMERALD_ANVIL_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.EMERALD_ANVIL_RECIPE_TYPE.get();
    }

    public RecipeCategory getCategory() {
        return this.category;
    }

    public int getRepairAmount() {
        return this.repairAmount;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }
}

