/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.items.actions.iron;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SpecialExplosion {
    private final ServerLevel level;
    private final Player player;
    private final BlockPos origin;
    private final float radius;
    private final List<BlockPos> destroyedBlocks;

    public SpecialExplosion(ServerLevel level, Player player, BlockPos origin, float radius) {
        this.level = level;
        this.player = player;
        this.origin = origin;
        this.radius = radius;
        this.destroyedBlocks = new ArrayList<BlockPos>();
    }

    public void trigger() {
        Vec3 lookVec = this.player.m_20154_().m_82541_();
        int effectiveRadius = (int)this.radius;
        int startX = this.origin.m_123341_() - effectiveRadius;
        int endX = this.origin.m_123341_() + effectiveRadius;
        int startY = this.origin.m_123342_() - effectiveRadius;
        int endY = this.origin.m_123342_() + effectiveRadius;
        int startZ = this.origin.m_123343_() - effectiveRadius;
        int endZ = this.origin.m_123343_() + effectiveRadius;
        if (Math.abs(lookVec.f_82479_) > Math.abs(lookVec.f_82480_) && Math.abs(lookVec.f_82479_) > Math.abs(lookVec.f_82481_)) {
            startX = this.origin.m_123341_() - effectiveRadius * 2;
            endX = this.origin.m_123341_() + effectiveRadius * 2;
        } else if (Math.abs(lookVec.f_82480_) > Math.abs(lookVec.f_82479_) && Math.abs(lookVec.f_82480_) > Math.abs(lookVec.f_82481_)) {
            startY = this.origin.m_123342_() - effectiveRadius * 2;
            endY = this.origin.m_123342_() + effectiveRadius * 2;
        } else {
            startZ = this.origin.m_123343_() - effectiveRadius * 2;
            endZ = this.origin.m_123343_() + effectiveRadius * 2;
        }
        this.explodeBlock(this.origin);
        this.level.m_5594_(null, this.origin, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level.m_5594_(null, this.origin, SoundEvents.f_12555_, SoundSource.BLOCKS, 1.0f, 0.8f);
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    BlockPos targetPos = new BlockPos(x, y, z);
                    if (targetPos.equals((Object)this.origin) || !this.canBeDestroyed(this.level.m_8055_(targetPos), targetPos)) continue;
                    this.explodeBlock(targetPos);
                    this.level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, 10, 0.1, 0.1, 0.1, 0.0);
                    if (!(Math.random() < 0.3)) continue;
                    this.level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, 5, 0.1, 0.1, 0.1, 0.0);
                }
            }
        }
    }

    private boolean canBeDestroyed(BlockState blockState, BlockPos pos) {
        float explosionResistance = blockState.getExplosionResistance((BlockGetter)this.level, pos, null);
        Block block = blockState.m_60734_();
        if (block == Blocks.f_50016_) {
            return false;
        }
        return explosionResistance < 2.0f && block != Blocks.f_50134_ ? Math.random() < 0.2 : Math.random() < 0.85;
    }

    private void explodeBlock(BlockPos pos) {
        BlockState blockState = this.level.m_8055_(pos);
        float explosionResistance = blockState.getExplosionResistance((BlockGetter)this.level, pos, null);
        if (explosionResistance <= 600.0f) {
            this.level.m_46953_(pos, true, (Entity)this.player);
            this.destroyedBlocks.add(pos);
        }
    }

    public int getDestroyedBlockCount() {
        return this.destroyedBlocks.size();
    }
}

