/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.items.actions.emerald;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EmeraldPickaxeBuff
extends PickaxeItem {
    public static final String EFFECTS_TAG = "EffectsEnabled";
    private boolean effectsEnabled = false;

    public EmeraldPickaxeBuff(Tier tier, int damage, float speed, Item.Properties properties) {
        super(tier, damage, speed, properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!world.f_46443_) {
            this.toggleFortune(itemStack, player);
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)true);
        }
        return super.m_7203_(world, player, hand);
    }

    private void toggleFortune(ItemStack itemStack, Player player) {
        CompoundTag tag = itemStack.m_41784_();
        this.effectsEnabled = !tag.m_128471_(EFFECTS_TAG);
        tag.m_128379_(EFFECTS_TAG, this.effectsEnabled);
        itemStack.m_41751_(tag);
        if (this.effectsEnabled) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, Integer.MAX_VALUE, 1, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19595_, Integer.MAX_VALUE, 1, false, true));
        } else {
            player.m_21195_(MobEffects.f_19621_);
            player.m_21195_(MobEffects.f_19595_);
        }
    }

    public boolean isEffectEnabled() {
        return this.effectsEnabled;
    }

    public void setEffectEnabled(boolean isEffectEnable) {
        this.effectsEnabled = isEffectEnable;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }
}

