/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.items.actions.amethyst;

import com.eruannie_9.minervillager.events.AmethystInfectionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class SpecialInfection {
    private final ServerLevel level;
    private final Player player;
    private final BlockPos origin;
    private final float radius;
    private final Set<BlockPos> infectedBlocks = new HashSet<BlockPos>();
    private final RandomSource random = RandomSource.m_216327_();
    private Iterator<BlockPos> iterator;

    public SpecialInfection(ServerLevel level, Player player, BlockPos origin, float radius) {
        this.level = level;
        this.player = player;
        this.origin = origin;
        this.radius = radius;
    }

    public void trigger() {
        this.infectBlock(this.origin);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(this.origin);
        this.infectedBlocks.add(this.origin);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockState targetState;
                        BlockPos target = current.m_7918_(x, y, z);
                        if (this.infectedBlocks.contains(target) || !(current.m_123331_((Vec3i)this.origin) <= (double)(this.radius * this.radius)) || !this.canBeInfected(targetState = this.level.m_8055_(target))) continue;
                        queue.add(target);
                        this.infectedBlocks.add(target);
                    }
                }
            }
        }
        this.createRippleEffect();
        AmethystInfectionEvent.registerInfection(this);
    }

    private boolean canBeInfected(BlockState state) {
        return !state.m_60795_() && !state.m_60819_().m_76170_() && !SpecialInfection.isAmethyst(state);
    }

    public static boolean isAmethyst(BlockState state) {
        return state.m_60713_(Blocks.f_152490_) || state.m_60713_(Blocks.f_152491_) || state.m_60713_(Blocks.f_152492_) || state.m_60713_(Blocks.f_152493_) || state.m_60713_(Blocks.f_152494_) || state.m_60713_(Blocks.f_152495_);
    }

    private void infectBlock(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        if (this.canBeInfected(state)) {
            BlockState newState = (double)this.random.m_188501_() < 0.1 ? Blocks.f_152491_.m_49966_() : Blocks.f_152490_.m_49966_();
            this.level.m_7731_(pos, newState, 3);
            this.level.m_142346_((Entity)this.player, GameEvent.f_157792_, pos);
            this.level.m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.placeCrystalAbove(pos);
        }
    }

    private void placeCrystalAbove(BlockPos pos) {
        BlockPos above = pos.m_7494_();
        BlockState aboveState = this.level.m_8055_(above);
        if (aboveState.m_60795_() && (double)this.random.m_188501_() < 0.1) {
            BlockState budState = switch (this.random.m_188503_(4)) {
                case 1 -> Blocks.f_152493_.m_49966_();
                case 2 -> Blocks.f_152494_.m_49966_();
                case 3 -> Blocks.f_152495_.m_49966_();
                default -> Blocks.f_152492_.m_49966_();
            };
            this.level.m_7731_(above, budState, 3);
            this.level.m_142346_((Entity)this.player, GameEvent.f_157797_, above);
            this.level.m_5594_(null, above, SoundEvents.f_144048_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void createRippleEffect() {
        ArrayList<BlockPos> sortedBlocks = new ArrayList<BlockPos>(this.infectedBlocks);
        sortedBlocks.sort(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)this.origin)));
        this.iterator = sortedBlocks.iterator();
    }

    public void processNextInfectionStep() {
        if (this.iterator != null && this.iterator.hasNext()) {
            this.infectBlock(this.iterator.next());
        } else {
            AmethystInfectionEvent.unregisterInfection(this);
        }
    }
}

