/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.items.actions.amethyst;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomDrop {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final double TRANSFORMATION_CHANCE = 0.2;

    public static void handleDrop(Level level, BlockPos pos, Player player) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = level.m_8055_(pos);
        if (RandomDrop.isAmethystBlock(state)) {
            List drops = RANDOM.m_188500_() < 0.2 ? RandomDrop.getBlockDrops(RandomDrop.getRandomBlockWithDrops(serverLevel), serverLevel, pos, player) : Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            for (ItemStack drop : drops) {
                RandomDrop.dropItem(serverLevel, pos, drop);
            }
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    private static boolean isAmethystBlock(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_152491_ || block == Blocks.f_152492_ || block == Blocks.f_152495_ || block == Blocks.f_152494_ || block == Blocks.f_152493_ || block instanceof AmethystBlock;
    }

    private static Block getRandomBlockWithDrops(ServerLevel level) {
        List<Block> validBlocks = ForgeRegistries.BLOCKS.getValues().stream().filter(block -> !RandomDrop.getBlockDrops(block, level, BlockPos.f_121853_, null).isEmpty()).toList();
        return validBlocks.get(RANDOM.m_188503_(validBlocks.size()));
    }

    private static List<ItemStack> getBlockDrops(Block block, ServerLevel level, BlockPos pos, Player player) {
        LootParams.Builder lootBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5)).m_287286_(LootContextParams.f_81463_, (Object)(player == null ? ItemStack.f_41583_ : player.m_21205_())).m_287289_(LootContextParams.f_81455_, (Object)player);
        return block.m_49966_().m_287290_(lootBuilder);
    }

    private static void dropItem(ServerLevel level, BlockPos pos, ItemStack itemStack) {
        level.m_7967_((Entity)new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack));
    }
}

