/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.items.actions.amethyst;

import com.eruannie_9.minervillager.items.actions.amethyst.SpecialInfection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AmethystInfection
extends PickaxeItem {
    private final int maxUses;
    private final int cooldown;
    private static final String USES_TAG = "Uses";

    public AmethystInfection(Tier tier, int damage, float speed, int maxUses, int cooldown, Item.Properties properties) {
        super(tier, damage, speed, properties);
        this.maxUses = maxUses;
        this.cooldown = cooldown;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (SpecialInfection.isAmethyst(state)) {
            return InteractionResult.PASS;
        }
        SpecialInfection specialInfection = new SpecialInfection((ServerLevel)level, player, pos, 2.0f);
        specialInfection.trigger();
        if (!player.m_7500_()) {
            ItemStack itemStack = context.m_43722_();
            CompoundTag tag = itemStack.m_41784_();
            int uses = tag.m_128451_(USES_TAG);
            int maxDamage = itemStack.m_41776_();
            int damagePerUse = maxDamage / this.maxUses;
            tag.m_128405_(USES_TAG, ++uses);
            itemStack.m_41751_(tag);
            itemStack.m_41622_(damagePerUse, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            player.m_36335_().m_41524_((Item)this, this.cooldown);
            if (uses >= this.maxUses) {
                player.m_21190_(context.m_43724_());
                itemStack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

