/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.events;

import com.eruannie_9.minervillager.items.actions.iron.IronPickaxeMagnet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MagnetEventHandler {
    private static final Map<ItemEntity, Long> itemInteractionStartTimes = new ConcurrentHashMap<ItemEntity, Long>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level world = player.m_9236_();
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        if (mainHandItem.m_41720_() instanceof IronPickaxeMagnet || offHandItem.m_41720_() instanceof IronPickaxeMagnet) {
            MagnetEventHandler.pullNearbyItems(world, player);
        } else {
            itemInteractionStartTimes.clear();
        }
    }

    private static void pullNearbyItems(Level world, Player player) {
        double radius = 8.0;
        world.m_45976_(ItemEntity.class, player.m_20191_().m_82400_(radius)).forEach(itemEntity -> {
            if (itemEntity.m_6084_()) {
                itemInteractionStartTimes.putIfAbsent((ItemEntity)itemEntity, System.currentTimeMillis());
                long elapsedTime = System.currentTimeMillis() - itemInteractionStartTimes.get(itemEntity);
                double pullSpeed = Math.min(0.05 + (double)elapsedTime / 1000.0 * 0.01, 0.2);
                MagnetEventHandler.pullItemEntityTowardsPlayer(itemEntity, player, radius, pullSpeed);
            }
        });
        List<ItemEntity> toRemove = itemInteractionStartTimes.keySet().stream().filter(itemEntity -> !itemEntity.m_6084_() || (double)itemEntity.m_20270_((Entity)player) > radius).toList();
        toRemove.forEach(itemInteractionStartTimes::remove);
    }

    private static void pullItemEntityTowardsPlayer(ItemEntity entity, Player player, double radius, double pullSpeed) {
        double dz;
        double dy;
        double dx = player.m_20185_() - entity.m_20185_();
        double distance = Math.sqrt(dx * dx + (dy = player.m_20186_() + (double)player.m_20192_() / 2.0 - entity.m_20186_()) * dy + (dz = player.m_20189_() - entity.m_20189_()) * dz);
        if (distance > 0.0) {
            double factor = Math.pow(1.0 - distance / radius, 2.0);
            entity.m_20256_(entity.m_20184_().m_82520_((dx /= distance) * pullSpeed * factor, (dy /= distance) * pullSpeed * factor, (dz /= distance) * pullSpeed * factor));
        }
    }
}

