/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.events;

import com.eruannie_9.minervillager.items.actions.emerald.EmeraldPickaxeBuff;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EmeraldDurabilityEvent {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EmeraldDurabilityEvent.handleMainHandAndInventoryItems(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerDestroyItem(PlayerDestroyItemEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack destroyedItem = event.getOriginal();
            Item item = destroyedItem.m_41720_();
            if (item instanceof EmeraldPickaxeBuff) {
                EmeraldPickaxeBuff emeraldPickaxeBuff = (EmeraldPickaxeBuff)item;
                EmeraldDurabilityEvent.disablePickaxeEffect(emeraldPickaxeBuff, player2);
            }
        }
    }

    private static void handleMainHandAndInventoryItems(ServerPlayer player) {
        long gameTime;
        EmeraldPickaxeBuff emeraldPickaxeBuff;
        ItemStack mainHandItem = player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (item instanceof EmeraldPickaxeBuff && (emeraldPickaxeBuff = (EmeraldPickaxeBuff)item).isEffectEnabled() && !player.m_7500_() && (gameTime = player.m_9236_().m_46467_()) % 20L == 0L) {
            mainHandItem.m_41622_(1, (LivingEntity)player, p -> {
                p.m_21190_(player.m_7655_());
                EmeraldDurabilityEvent.disablePickaxeEffect(emeraldPickaxeBuff, p);
            });
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof EmeraldPickaxeBuff)) continue;
            EmeraldPickaxeBuff emeraldPickaxeBuff2 = (EmeraldPickaxeBuff)item2;
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128471_("EffectsEnabled") || stack == mainHandItem) continue;
            tag.m_128379_("EffectsEnabled", false);
            stack.m_41751_(tag);
            EmeraldDurabilityEvent.disablePickaxeEffect(emeraldPickaxeBuff2, player);
        }
    }

    private static void disablePickaxeEffect(EmeraldPickaxeBuff emeraldPickaxeBuff, ServerPlayer player) {
        emeraldPickaxeBuff.setEffectEnabled(false);
        player.m_21195_(MobEffects.f_19621_);
        player.m_21195_(MobEffects.f_19595_);
    }
}

