/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.events;

import com.eruannie_9.minervillager.items.actions.amethyst.SpecialInfection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AmethystInfectionEvent {
    private static final List<SpecialInfection> activeInfections = new CopyOnWriteArrayList<SpecialInfection>();
    private static int tickCounter = 0;
    private static final int TICK_INTERVAL = 5;

    public static void registerInfection(SpecialInfection infection) {
        activeInfections.add(infection);
    }

    public static void unregisterInfection(SpecialInfection infection) {
        activeInfections.remove(infection);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++tickCounter >= 5) {
            activeInfections.forEach(SpecialInfection::processNextInfectionStep);
            tickCounter = 0;
        }
    }
}

