/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.entity.profession;

import java.util.function.Function;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class RandomTradeBuilder {
    protected Function<RandomSource, ItemStack> price = null;
    protected Function<RandomSource, ItemStack> price2 = random -> ItemStack.f_41583_;
    protected Function<RandomSource, ItemStack> forSale = null;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;

    public RandomTradeBuilder(int maxTrades, int xp, float priceMult) {
        this.maxTrades = maxTrades;
        this.xp = xp;
        this.priceMult = priceMult;
    }

    public RandomTradeBuilder setPrice(Function<RandomSource, ItemStack> price) {
        this.price = price;
        return this;
    }

    public RandomTradeBuilder setPrice(Item item, int min, int max) {
        return this.setPrice(RandomTradeBuilder.createFunction(item, min, max));
    }

    public RandomTradeBuilder setPrice2(Function<RandomSource, ItemStack> price2) {
        this.price2 = price2;
        return this;
    }

    public RandomTradeBuilder setPrice2(Item item, int min, int max) {
        return this.setPrice2(RandomTradeBuilder.createFunction(item, min, max));
    }

    public RandomTradeBuilder setForSale(Function<RandomSource, ItemStack> forSale) {
        this.forSale = forSale;
        return this;
    }

    public RandomTradeBuilder setForSale(Item item, int min, int max) {
        return this.setForSale(RandomTradeBuilder.createFunction(item, min, max));
    }

    public RandomTradeBuilder setForSale(ItemStack itemStack) {
        return this.setForSale((RandomSource random) -> itemStack);
    }

    public RandomTradeBuilder setEmeraldPrice(int emeralds) {
        return this.setPrice(random -> new ItemStack((ItemLike)Items.f_42616_, emeralds));
    }

    public RandomTradeBuilder setEmeraldPriceFor(int emeralds, Item item, int amt) {
        this.setEmeraldPrice(emeralds);
        return this.setForSale((RandomSource random) -> new ItemStack((ItemLike)item, amt));
    }

    public RandomTradeBuilder setEmeraldPriceFor(int emeralds, Item item) {
        return this.setEmeraldPriceFor(emeralds, item, 1);
    }

    public RandomTradeBuilder setEmeraldPrice(int min, int max) {
        return this.setPrice(Items.f_42616_, min, max);
    }

    public RandomTradeBuilder setEmeraldPriceFor(int min, int max, Item item, int amt) {
        this.setEmeraldPrice(min, max);
        return this.setForSale((RandomSource random) -> new ItemStack((ItemLike)item, amt));
    }

    public RandomTradeBuilder setEmeraldPriceFor(int min, int max, Item item) {
        return this.setEmeraldPriceFor(min, max, item, 1);
    }

    public boolean canBuild() {
        return this.price != null && this.forSale != null;
    }

    public VillagerTrades.ItemListing build() {
        return (entity, random) -> !this.canBuild() ? null : new MerchantOffer(this.price.apply(random), this.price2.apply(random), this.forSale.apply(random), this.maxTrades, this.xp, this.priceMult);
    }

    public static Function<RandomSource, ItemStack> createFunction(Item item, int min, int max) {
        return random -> new ItemStack((ItemLike)item, random.m_188503_(max - min + 1) + min);
    }

    public RandomTradeBuilder setForSaleEnchantedBook(Enchantment enchantment, int minLevel, int maxLevel) {
        this.forSale = random -> {
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            int level = minLevel + random.m_188503_(maxLevel - minLevel + 1);
            EnchantedBookItem.m_41153_((ItemStack)enchantedBook, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
            return enchantedBook;
        };
        return this;
    }
}

