/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.entity.miner.proprities.goals;

import com.eruannie_9.minervillager.entity.miner.MinerVillagerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RandomWalkAndTorchPlacement
extends RandomStrollGoal {
    private final double range;
    private BlockPos lastTorchPos;

    public RandomWalkAndTorchPlacement(PathfinderMob mob, double speedModifier, double range) {
        super(mob, speedModifier);
        this.range = range;
    }

    public boolean m_8036_() {
        return super.m_8036_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.isLowLight()) {
            this.placeTorch();
        }
    }

    private boolean isLowLight() {
        Vec3 lookVec;
        BlockPos mobPosition = this.f_25725_.m_20183_();
        ServerLevel world = (ServerLevel)this.f_25725_.m_9236_();
        int lightLevel = world.m_45517_(LightLayer.BLOCK, mobPosition);
        if (lightLevel >= 8) {
            return false;
        }
        Vec3 eyePosition = this.f_25725_.m_20299_(1.0f);
        BlockHitResult rayTraceResult = world.m_45547_(new ClipContext(eyePosition, lookVec = eyePosition.m_82549_(this.f_25725_.m_20154_().m_82490_(this.range)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.f_25725_));
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            Direction direction;
            BlockPos targetBlockPos = rayTraceResult.m_82425_();
            BlockPos wallBlockPos = targetBlockPos.m_121945_(direction = rayTraceResult.m_82434_());
            return world.m_45517_(LightLayer.BLOCK, wallBlockPos) < 8;
        }
        return false;
    }

    private void placeTorch() {
        Vec3 eyePosition = this.f_25725_.m_20299_(1.0f);
        Vec3 lookVec = eyePosition.m_82549_(this.f_25725_.m_20154_().m_82490_(this.range));
        ServerLevel world = (ServerLevel)this.f_25725_.m_9236_();
        BlockHitResult rayTraceResult = world.m_45547_(new ClipContext(eyePosition, lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.f_25725_));
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos targetBlockPos = rayTraceResult.m_82425_();
            Direction direction = rayTraceResult.m_82434_();
            BlockPos wallBlockPos = targetBlockPos.m_121945_(direction);
            if (!Direction.Plane.HORIZONTAL.test(direction)) {
                return;
            }
            BlockState wallTorchState = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)direction);
            if (this.lastTorchPos != null && world.m_8055_(this.lastTorchPos).m_60734_() == Blocks.f_50082_) {
                world.m_7731_(this.lastTorchPos, Blocks.f_50016_.m_49966_(), 3);
            }
            if (world.m_8055_(targetBlockPos).m_60783_((BlockGetter)world, targetBlockPos, direction) && wallTorchState.m_60710_((LevelReader)world, wallBlockPos)) {
                world.m_7731_(wallBlockPos, wallTorchState, 3);
                world.m_5594_(null, wallBlockPos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.lastTorchPos = wallBlockPos;
                if (this.f_25725_ instanceof MinerVillagerEntity) {
                    ((MinerVillagerEntity)this.f_25725_).setLastTorchPos(wallBlockPos);
                }
            }
        }
    }
}

