/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.entity.miner.proprities.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class PanicGoal
extends Goal {
    private final PathfinderMob creature;
    private final double speed;
    private Vec3 directionAwayFromAttacker;
    private boolean isCorneredWhenAttacked;
    private boolean isRunningRandomly;

    public PanicGoal(PathfinderMob creature, double speedIn) {
        this.creature = creature;
        this.speed = speedIn;
    }

    public boolean m_8036_() {
        if (this.creature.m_6060_()) {
            return true;
        }
        if (this.creature.m_21188_() != null) {
            Vec3 creaturePos = this.creature.m_20182_();
            this.isCorneredWhenAttacked = this.isCornered(new BlockPos((int)creaturePos.f_82479_, (int)creaturePos.f_82480_, (int)creaturePos.f_82481_));
            return true;
        }
        return false;
    }

    public void m_8056_() {
        if (this.creature.m_21188_() != null && !this.creature.m_6060_()) {
            this.directionAwayFromAttacker = this.creature.m_21188_().m_20182_().m_82546_(this.creature.m_20182_()).m_82541_();
            Vec3 targetPosition = this.findSafePosition(this.creature.m_20182_().m_82549_(this.directionAwayFromAttacker.m_82490_(-5.0)));
            this.creature.m_21573_().m_26519_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, this.speed);
        } else if (this.creature.m_6060_()) {
            this.isRunningRandomly = true;
            this.randomRunning();
        }
    }

    public void m_8037_() {
        block4: {
            block3: {
                if (!this.creature.m_6060_() || !this.isRunningRandomly) break block3;
                if (!this.creature.m_21573_().m_26571_()) break block4;
                this.randomRunning();
                break block4;
            }
            if (this.creature.m_21188_() != null && !this.creature.m_6060_() && this.creature.m_20280_((Entity)this.creature.m_21188_()) > 25.0) {
                PathNavigation navigator = this.creature.m_21573_();
                for (int attempt = 0; attempt < 10; ++attempt) {
                    Vec3 randomOffset = new Vec3((this.creature.m_217043_().m_188500_() - 0.5) / 4.0, 0.0, (this.creature.m_217043_().m_188500_() - 0.5) / 4.0);
                    Vec3 randomDirection = this.directionAwayFromAttacker.m_82549_(randomOffset).m_82541_();
                    if (randomDirection.m_82526_(this.directionAwayFromAttacker) < 0.0) {
                        randomDirection = this.directionAwayFromAttacker;
                    }
                    Vec3 targetPosition = this.findSafePosition(this.creature.m_20182_().m_82549_(randomDirection.m_82490_(-5.0)));
                    Path path = navigator.m_7864_(new BlockPos((int)targetPosition.f_82479_, (int)targetPosition.f_82480_, (int)targetPosition.f_82481_), 0);
                    if (path == null || !path.m_77403_()) continue;
                    navigator.m_26519_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, this.speed);
                    break;
                }
            }
        }
    }

    public boolean m_8045_() {
        return !this.creature.m_6060_() && this.creature.m_21188_() != null && !this.creature.m_21573_().m_26571_() || this.creature.m_6060_() && this.isRunningRandomly;
    }

    public void m_8041_() {
        this.creature.m_21573_().m_26573_();
        this.isRunningRandomly = false;
    }

    private Vec3 findSafePosition(Vec3 initialPosition) {
        LivingEntity lastHurtByMob;
        BlockPos pos = new BlockPos((int)initialPosition.f_82479_, (int)initialPosition.f_82480_, (int)initialPosition.f_82481_);
        while (this.creature.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13131_) || this.creature.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13132_)) {
            pos = pos.m_7494_();
        }
        if (this.isCorneredWhenAttacked && (lastHurtByMob = this.creature.m_21188_()) != null) {
            Vec3 towardsAttacker = lastHurtByMob.m_20182_().m_82546_(this.creature.m_20182_()).m_82541_();
            Vec3 newPosition = this.creature.m_20182_().m_82549_(towardsAttacker.m_82490_(5.0));
            pos = new BlockPos((int)newPosition.f_82479_, (int)newPosition.f_82480_, (int)newPosition.f_82481_);
            if (!this.isCornered(pos)) {
                this.isCorneredWhenAttacked = false;
            }
        }
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    private boolean isCornered(BlockPos position) {
        BlockState north = this.creature.m_9236_().m_8055_(position.m_122012_());
        BlockState east = this.creature.m_9236_().m_8055_(position.m_122029_());
        BlockState south = this.creature.m_9236_().m_8055_(position.m_122019_());
        BlockState west = this.creature.m_9236_().m_8055_(position.m_122024_());
        boolean northEastCorner = north.m_60815_() && east.m_60815_();
        boolean northWestCorner = north.m_60815_() && west.m_60815_();
        boolean southEastCorner = south.m_60815_() && east.m_60815_();
        boolean southWestCorner = south.m_60815_() && west.m_60815_();
        return northEastCorner || northWestCorner || southEastCorner || southWestCorner;
    }

    private void randomRunning() {
        double randomX = this.creature.m_20185_() + (this.creature.m_217043_().m_188500_() - 0.5) * 8.0;
        double randomY = this.creature.m_20186_() + (double)(this.creature.m_217043_().m_188503_(16) - 8);
        double randomZ = this.creature.m_20189_() + (this.creature.m_217043_().m_188500_() - 0.5) * 8.0;
        this.creature.m_21573_().m_26519_(randomX, randomY, randomZ, this.speed);
    }
}

