/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.entity.miner.proprities;

import com.eruannie_9.minervillager.ModConfiguration;
import com.eruannie_9.minervillager.entity.ModEntityTypes;
import com.eruannie_9.minervillager.entity.miner.MinerVillagerEntity;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MinerVillagerSpawn {
    public static final int MAX_ENTITY_PER_ROOM = 1;
    public static final int DELAY = 100;
    public static final Map<BoundingBox, AtomicInteger> minerCountPerRoom = new HashMap<BoundingBox, AtomicInteger>();
    private static long lastSpawnTime = 0L;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.level.f_46443_) {
            return;
        }
        long currentTime = event.level.m_46467_();
        if (currentTime - lastSpawnTime < 100L) {
            return;
        }
        lastSpawnTime = currentTime;
        for (Player player : event.level.m_6907_()) {
            MinerVillagerSpawn.spawnMinerNearPlayer(event.level, player);
        }
    }

    private static void spawnMinerNearPlayer(Level world, Player player) {
        int chunkRange = 3;
        int playerChunkX = player.m_20183_().m_123341_() >> 4;
        int playerChunkZ = player.m_20183_().m_123343_() >> 4;
        for (int xOffset = -chunkRange; xOffset <= chunkRange; ++xOffset) {
            for (int zOffset = -chunkRange; zOffset <= chunkRange; ++zOffset) {
                LevelChunk chunk = world.m_6325_(playerChunkX + xOffset, playerChunkZ + zOffset);
                for (StructureStart structureStart : chunk.m_6633_().values()) {
                    if (!MinerVillagerSpawn.isMineshaftStructure(structureStart)) continue;
                    MinerVillagerSpawn.spawnMinerInMineshaft(world, structureStart);
                }
            }
        }
    }

    private static void spawnMinerInMineshaft(Level world, StructureStart structureStart) {
        List<BoundingBox> eligibleRooms = MinerVillagerSpawn.getEligibleRooms(structureStart);
        if (eligibleRooms.isEmpty()) {
            return;
        }
        RandomSource random = world.f_46441_;
        BoundingBox selectedRoom = eligibleRooms.get(random.m_188503_(eligibleRooms.size()));
        if (random.m_188500_() < (Double)ModConfiguration.MINER_SPAWN_PROBABILITY.get()) {
            BlockPos spawnPos = new BlockPos(selectedRoom.m_162395_() + random.m_188503_(selectedRoom.m_71056_()), selectedRoom.m_162396_() + random.m_188503_(selectedRoom.m_71057_()), selectedRoom.m_162398_() + random.m_188503_(selectedRoom.m_71058_()));
            MinerVillagerEntity minerVillagerEntity = (MinerVillagerEntity)((EntityType)ModEntityTypes.MINER_VILLAGER.get()).m_20615_(world);
            if (minerVillagerEntity != null) {
                minerVillagerEntity.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                minerVillagerEntity.setRoomBoundingBox(selectedRoom);
                world.m_7967_((Entity)minerVillagerEntity);
                minerCountPerRoom.get(selectedRoom).incrementAndGet();
            }
        }
    }

    private static boolean isMineshaftStructure(StructureStart structureStart) {
        boolean isMineshaft = structureStart.m_226861_() instanceof MineshaftStructure;
        if (ModList.get().isLoaded("bettermineshafts")) {
            isMineshaft = isMineshaft || structureStart.m_226861_() instanceof BetterMineshaftStructure;
        }
        return isMineshaft;
    }

    private static List<BoundingBox> getEligibleRooms(StructureStart structureStart) {
        ArrayList<BoundingBox> eligibleRooms = new ArrayList<BoundingBox>();
        for (StructurePiece piece : structureStart.m_73602_()) {
            BoundingBox boundingBox;
            AtomicInteger minersInRoom;
            boolean isEligiblePiece;
            boolean bl = isEligiblePiece = piece instanceof MineshaftPieces.MineShaftCorridor || piece instanceof MineshaftPieces.MineShaftCrossing || piece instanceof MineshaftPieces.MineShaftRoom || piece instanceof MineshaftPieces.MineShaftStairs;
            if (ModList.get().isLoaded("bettermineshafts")) {
                boolean bl2 = isEligiblePiece = isEligiblePiece || piece instanceof BetterMineshaftPiece;
            }
            if (!isEligiblePiece || (minersInRoom = minerCountPerRoom.computeIfAbsent(boundingBox = piece.m_73547_(), k -> new AtomicInteger(0))).get() >= 1) continue;
            eligibleRooms.add(boundingBox);
        }
        return eligibleRooms;
    }
}

