/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.entity.miner;

import com.eruannie_9.minervillager.entity.miner.proprities.MinerVillagerSpawn;
import com.eruannie_9.minervillager.entity.miner.proprities.goals.PanicGoal;
import com.eruannie_9.minervillager.entity.miner.proprities.goals.RandomWalkAndTorchPlacement;
import com.eruannie_9.minervillager.entity.profession.ModVillagers;
import com.eruannie_9.minervillager.items.ModItems;
import com.eruannie_9.minervillager.util.villager.IMinerVillagerLogic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MinerVillagerEntity
extends Villager
implements GeoEntity,
IMinerVillagerLogic {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42616_, Items.f_42415_, Items.f_42414_});
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static List<MinerVillagerEntity> miners = new ArrayList<MinerVillagerEntity>();
    private final Map<Integer, Integer> tradeCounters = new HashMap<Integer, Integer>();
    private static final int TICKS_BEFORE_RESET = 24000;
    private BoundingBox roomBoundingBox;
    public BlockPos lastTorchPos;

    public MinerVillagerEntity(EntityType<? extends Villager> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        miners.add(this);
        if (this.m_35504_()) {
            this.m_34375_(this.m_7141_().m_35565_((VillagerProfession)ModVillagers.MINER.get()));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22279_, 0.4);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.4, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new RandomWalkAndTorchPlacement((PathfinderMob)this, 0.4, 3.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
    }

    public int m_213860_() {
        return 3 + this.m_9236_().f_46441_.m_188503_(3);
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 1.0f, 1.0f);
    }

    public void setRoomBoundingBox(BoundingBox boundingBox) {
        this.roomBoundingBox = boundingBox;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult actionResult = super.m_6071_(player, hand);
        if (!this.m_9236_().f_46443_ && !player.m_6144_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11678_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return actionResult;
    }

    public void m_8119_() {
        super.m_8119_();
        for (Map.Entry<Integer, Integer> tradeEntry : this.tradeCounters.entrySet()) {
            int tradeIndex = tradeEntry.getKey();
            int counter = tradeEntry.getValue();
            if (++counter >= 24000) {
                this.resetTradeStock(tradeIndex);
                counter = 0;
            }
            tradeEntry.setValue(counter);
        }
    }

    public void m_6996_(@NotNull MerchantOffer offer) {
        super.m_6996_(offer);
        if (this.f_35261_ != null) {
            int tradeIndex = this.f_35261_.indexOf((Object)offer);
            this.tradeCounters.put(tradeIndex, 0);
        }
    }

    private void resetTradeStock(int tradeIndex) {
        if (this.f_35261_ != null && tradeIndex >= 0 && tradeIndex < this.f_35261_.size()) {
            MerchantOffer offer = (MerchantOffer)this.f_35261_.get(tradeIndex);
            ItemStack sellingItem = offer.m_45368_();
            if (this.isScrollItem(sellingItem.m_41720_())) {
                return;
            }
            offer.m_45372_();
        }
    }

    private boolean isScrollItem(Item item) {
        return item == ModItems.SCROLL_BUFF.get() || item == ModItems.SCROLL_INFECTION.get() || item == ModItems.SCROLL_EXPLOSION.get() || item == ModItems.SCROLL_LUCK.get() || item == ModItems.SCROLL_SPOT.get() || item == ModItems.SCROLL_MAGNET.get();
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        miners.remove(this);
        AtomicInteger minerCount = MinerVillagerSpawn.minerCountPerRoom.get(this.roomBoundingBox);
        if (minerCount != null) {
            minerCount.decrementAndGet();
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (this.lastTorchPos != null) {
            tag.m_128356_("lastTorchPos", this.lastTorchPos.m_121878_());
        }
        ListTag tradeCountersList = new ListTag();
        for (Map.Entry<Integer, Integer> entry : this.tradeCounters.entrySet()) {
            CompoundTag tradeTag = new CompoundTag();
            tradeTag.m_128405_("TradeIndex", entry.getKey().intValue());
            tradeTag.m_128405_("Counter", entry.getValue().intValue());
            tradeCountersList.add((Object)tradeTag);
        }
        tag.m_128365_("TradeCounters", (Tag)tradeCountersList);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("lastTorchPos")) {
            this.lastTorchPos = BlockPos.m_122022_((long)tag.m_128454_("lastTorchPos"));
        }
        if (tag.m_128425_("TradeCounters", 9)) {
            ListTag tradeCountersList = tag.m_128437_("TradeCounters", 10);
            this.tradeCounters.clear();
            for (int i = 0; i < tradeCountersList.size(); ++i) {
                CompoundTag tradeTag = tradeCountersList.m_128728_(i);
                int tradeIndex = tradeTag.m_128451_("TradeIndex");
                int counter = tradeTag.m_128451_("Counter");
                this.tradeCounters.put(tradeIndex, counter);
            }
        }
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar manager) {
        manager.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public BlockPos getLastTorchPos() {
        return this.lastTorchPos;
    }

    public void setLastTorchPos(BlockPos pos) {
        this.lastTorchPos = pos;
    }

    public boolean m_35506_() {
        return false;
    }

    @Override
    public boolean CustomInitBrain() {
        return true;
    }

    public boolean m_35504_() {
        return true;
    }
}

