/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.entity.glow;

import com.eruannie_9.minervillager.entity.glow.GlowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GlowEntityRenderer
extends EntityRenderer<GlowEntity> {
    private final BlockRenderDispatcher dispatcher;

    public GlowEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.dispatcher = context.m_234597_();
    }

    public void render(GlowEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        BlockPos entityPos;
        Level level;
        BlockState blockState = entity.getBlockState();
        if (blockState.m_60799_() == RenderShape.MODEL && blockState != (level = entity.m_9236_()).m_8055_(entityPos = entity.m_20183_()) && blockState.m_60799_() != RenderShape.INVISIBLE) {
            poseStack.m_85836_();
            BlockPos blockPos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20191_().f_82292_, (double)entity.m_20189_());
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            BakedModel model = this.dispatcher.m_110910_(blockState);
            RandomSource randomSource = RandomSource.m_216335_((long)blockState.m_60726_(entity.getStartPos()));
            ChunkRenderTypeSet renderTypes = model.getRenderTypes(blockState, randomSource, ModelData.EMPTY);
            for (RenderType renderType : renderTypes) {
                FullBrightnessVertex vertexConsumer = new FullBrightnessVertex(bufferSource.m_6299_(renderType));
                this.dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)level, model, blockState, blockPos, poseStack, (VertexConsumer)vertexConsumer, false, randomSource, blockState.m_60726_(entity.getStartPos()), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
            }
            poseStack.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GlowEntity entity) {
        return TextureAtlas.f_118259_;
    }

    private record FullBrightnessVertex(VertexConsumer inner) implements VertexConsumer
    {
        @NotNull
        public VertexConsumer m_5483_(double x, double y, double z) {
            return this.inner.m_5483_(x, y, z);
        }

        @NotNull
        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return this.inner.m_6122_(red, green, blue, alpha);
        }

        @NotNull
        public VertexConsumer m_7421_(float u, float v) {
            return this.inner.m_7421_(u, v);
        }

        @NotNull
        public VertexConsumer m_7122_(int u, int v) {
            return this.inner.m_7122_(u, v);
        }

        @NotNull
        public VertexConsumer m_7120_(int u, int v) {
            return this.inner.m_85969_(0xF000F0);
        }

        @NotNull
        public VertexConsumer m_5601_(float x, float y, float z) {
            return this.inner.m_5601_(x, y, z);
        }

        public void m_5752_() {
            this.inner.m_5752_();
        }

        public void m_7404_(int red, int green, int blue, int alpha) {
            this.inner.m_7404_(red, green, blue, alpha);
        }

        public void m_141991_() {
            this.inner.m_141991_();
        }
    }
}

