/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.entity.glow;

import com.eruannie_9.minervillager.block.ModBlocks;
import com.eruannie_9.minervillager.entity.ModEntityTypes;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlowEntity
extends Entity {
    private BlockState blockState;
    @Nullable
    private BlockPos startPos = BlockPos.f_121853_;
    private long spawnTime;
    private long hitTime = -1L;
    private long interactTime = -1L;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(GlowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public GlowEntity(EntityType<? extends GlowEntity> type, Level level) {
        super(type, level);
        this.blockState = Blocks.f_49992_.m_49966_();
    }

    public GlowEntity(Level level, double x, double y, double z, BlockState blockState) {
        this((EntityType<? extends GlowEntity>)((EntityType)ModEntityTypes.GLOW_ENTITY.get()), level);
        this.blockState = blockState;
        this.m_6034_(x, y, z);
        this.startPos = this.m_20183_();
        this.m_146915_(true);
        this.m_20011_(new AABB(this.m_20183_(), this.m_20183_().m_7918_(1, 1, 1)));
        this.spawnTime = level.m_46467_();
    }

    public static GlowEntity create(Level level, BlockPos pos, BlockState blockState) {
        return new GlowEntity(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, blockState);
    }

    public void m_8119_() {
        long currentTime = this.m_9236_().m_46467_();
        long elapsedTime = currentTime - this.spawnTime;
        if (elapsedTime == 98L && this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)ModBlocks.SOLID_AIR.get())) {
            this.replaceBlock();
        }
        if (elapsedTime >= 100L) {
            this.m_146870_();
        }
        if (this.hitTime != -1L && currentTime - this.hitTime >= 2L) {
            this.m_146870_();
        }
        if (this.interactTime != -1L && currentTime - this.interactTime >= 2L) {
            this.m_146870_();
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (!this.m_9236_().m_5776_()) {
            if ("explosion".equals(source.m_19385_())) {
                float blockResistance = this.blockState.m_60734_().m_7325_();
                if (amount >= blockResistance) {
                    Block.m_49892_((BlockState)this.blockState, (LevelAccessor)this.m_9236_(), (BlockPos)this.m_20183_(), null);
                    this.m_9236_().m_7731_(this.m_20183_(), Blocks.f_50016_.m_49966_(), 3);
                } else {
                    this.replaceBlock();
                }
                this.m_146870_();
            } else {
                if (this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)ModBlocks.SOLID_AIR.get())) {
                    this.replaceBlock();
                }
                this.hitTime = this.m_9236_().m_46467_();
            }
        }
        return true;
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)ModBlocks.SOLID_AIR.get())) {
                this.replaceBlock();
            }
            this.interactTime = this.m_9236_().m_46467_();
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)ModBlocks.SOLID_AIR.get())) {
            this.m_9236_().m_7731_(this.m_20183_(), this.blockState, 3);
        }
        super.m_142687_(reason);
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_6478_(@NotNull MoverType type, @NotNull Vec3 pos) {
        if (type == MoverType.SELF) {
            super.m_6478_(type, Vec3.f_82478_);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    protected void m_7378_(CompoundTag tag) {
        this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState"));
        this.spawnTime = tag.m_128454_("SpawnTime");
        this.hitTime = tag.m_128454_("HitTime");
        this.interactTime = tag.m_128454_("InteractTime");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        tag.m_128356_("SpawnTime", this.spawnTime);
        tag.m_128356_("HitTime", this.hitTime);
        tag.m_128356_("InteractTime", this.interactTime);
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.blockState = Block.m_49803_((int)packet.m_131509_());
        double x = packet.m_131500_();
        double y = packet.m_131501_();
        double z = packet.m_131502_();
        this.m_6034_(x, y, z);
        this.startPos = this.m_20183_();
        this.m_20011_(new AABB(this.m_20183_(), this.m_20183_().m_7918_(1, 1, 1)));
        this.spawnTime = this.m_9236_().m_46467_();
        this.hitTime = -1L;
        this.interactTime = -1L;
    }

    public void m_7976_(CrashReportCategory p_31962_) {
        super.m_7976_(p_31962_);
        p_31962_.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    @NotNull
    protected Component m_5677_() {
        return Component.m_237110_((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{this.blockState.m_60734_().m_49954_()});
    }

    public boolean m_6051_() {
        return false;
    }

    public void replaceBlock() {
        this.m_9236_().m_7731_(this.m_20183_(), this.blockState, 3);
    }

    public BlockState getBlockStateForParticles() {
        return this.blockState;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6127_() {
        return true;
    }

    @Nullable
    public BlockPos getStartPos() {
        return this.startPos;
    }
}

