/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.block.menu;

import com.eruannie_9.minervillager.block.ModBlocks;
import com.eruannie_9.minervillager.block.gui.ModScreen;
import com.eruannie_9.minervillager.recipe.EmeraldAnvilRecipe;
import com.eruannie_9.minervillager.recipe.ModRecipes;
import com.eruannie_9.minervillager.sound.ModSound;
import com.eruannie_9.minervillager.util.RecipeCategory;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EmeraldAnvilMenu
extends ItemCombinerMenu {
    public EmeraldAnvilMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public EmeraldAnvilMenu(int id, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)ModScreen.EMERALD_ANVIL.get(), id, playerInventory, access);
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    protected boolean m_6560_(@NotNull Player player, boolean hasStack) {
        return true;
    }

    protected void m_142365_(Player player, @NotNull ItemStack stack) {
        Level world = player.m_9236_();
        ItemStack input1 = this.f_39769_.m_8020_(0);
        ItemStack input2 = this.f_39769_.m_8020_(1);
        Optional recipe = world.m_7465_().m_44015_((RecipeType)ModRecipes.EMERALD_ANVIL_RECIPE_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{input1, input2}), world);
        if (recipe.isPresent()) {
            EmeraldAnvilRecipe emeraldAnvilRecipe = (EmeraldAnvilRecipe)recipe.get();
            if (emeraldAnvilRecipe.getCategory() == RecipeCategory.REPAIR) {
                int repairAmount = emeraldAnvilRecipe.getRepairAmount();
                int damageRestored = input1.m_41773_() - stack.m_41773_();
                int itemsConsumed = (int)Math.ceil((double)damageRestored / (double)repairAmount);
                itemsConsumed = Math.min(itemsConsumed, input2.m_41613_());
                input2.m_41774_(itemsConsumed);
                int totalRepairAmount = itemsConsumed * repairAmount;
                input1.m_41721_(Math.max(0, input1.m_41773_() - totalRepairAmount));
                input1.m_41774_(1);
            } else {
                input1.m_41774_(1);
                input2.m_41774_(1);
            }
        } else {
            input1.m_41774_(1);
            input2.m_41774_(1);
        }
        if (!world.f_46443_) {
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSound.HAMMER_SMASH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        this.m_38946_();
        this.m_6640_();
    }

    protected boolean m_8039_(BlockState state) {
        return state.m_60713_((Block)ModBlocks.EMERALD_ANVIL.get());
    }

    public void m_6640_() {
        this.createResultWithRegistryAccess(this.f_39771_.m_9236_().m_9598_());
    }

    public void createResultWithRegistryAccess(RegistryAccess registryAccess) {
        ItemStack input1 = this.f_39769_.m_8020_(0);
        ItemStack input2 = this.f_39769_.m_8020_(1);
        if (!input1.m_41619_() && !input2.m_41619_()) {
            Level world = this.f_39771_.m_9236_();
            Optional recipe = world.m_7465_().m_44015_((RecipeType)ModRecipes.EMERALD_ANVIL_RECIPE_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{input1, input2}), world);
            if (recipe.isPresent()) {
                EmeraldAnvilRecipe emeraldAnvilRecipe = (EmeraldAnvilRecipe)recipe.get();
                ItemStack result = emeraldAnvilRecipe.m_5874_((Container)new SimpleContainer(new ItemStack[]{input1, input2}), registryAccess);
                if (emeraldAnvilRecipe.getCategory() == RecipeCategory.REPAIR) {
                    result = input1.m_41777_();
                    int damageValue = result.m_41773_();
                    int itemsAvailable = input2.m_41613_();
                    int totalRepairAmount = itemsAvailable * emeraldAnvilRecipe.getRepairAmount();
                    int repairAmountToApply = Math.min(damageValue, totalRepairAmount);
                    result.m_41721_(damageValue - repairAmountToApply);
                }
                this.f_39768_.m_6836_(0, result);
            } else {
                this.f_39768_.m_6836_(0, ItemStack.f_41583_);
            }
        } else {
            this.f_39768_.m_6836_(0, ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, stack -> true).m_266197_(1, 76, 47, stack -> true).m_266198_(2, 134, 47).m_266441_();
    }

    public void m_6199_(@NotNull Container inventoryIn) {
        super.m_6199_(inventoryIn);
        this.m_6640_();
    }
}

