/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.minervillager.block.gui;

import com.eruannie_9.minervillager.block.gui.Texture;
import com.eruannie_9.minervillager.block.menu.EmeraldAnvilMenu;
import com.eruannie_9.minervillager.items.ModItems;
import com.eruannie_9.minervillager.util.ModTags;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EmeraldAnvilScreen
extends ItemCombinerScreen<EmeraldAnvilMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("minervillager", "textures/gui/emerald_anvil.png");
    private final long startTime = System.currentTimeMillis();

    public EmeraldAnvilScreen(EmeraldAnvilMenu screenContainer, Inventory inv, Component titleIn) {
        super((ItemCombinerMenu)screenContainer, inv, titleIn, GUI_TEXTURE);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.renderDefault(guiGraphics, i, j, 0, 0, this.f_97726_, this.f_97727_);
        ItemStack itemStackInSlot0 = this.getItemStackInSlot(0);
        ItemStack itemStackInSlot1 = this.getItemStackInSlot(1);
        boolean hasBasePickaxe = this.isBasePickaxe(itemStackInSlot0);
        boolean isPickaxeDamaged = itemStackInSlot0.m_41768_();
        boolean hasScroll = itemStackInSlot1.m_204117_(ModTags.Items.SCROLLS);
        boolean hasRepairItem = itemStackInSlot1.m_204117_(ModTags.Items.REPAIR_MATERIAL);
        boolean hasMatchingSet = this.isMatchingSet(itemStackInSlot0, itemStackInSlot1);
        boolean hasRepairingSet = isPickaxeDamaged && this.isMatchingRepair(itemStackInSlot0, itemStackInSlot1);
        this.renderSlot(guiGraphics, i, j, 0, Texture.Coords.VOID_SLOT);
        this.renderSlot(guiGraphics, i, j, 1, Texture.Coords.VOID_SLOT);
        if (((EmeraldAnvilMenu)this.f_97732_).m_38853_(2).m_6657_()) {
            this.renderSlot(guiGraphics, i + 9, j, 2, Texture.Coords.VOID_SLOT);
        }
        if (itemStackInSlot0 != ItemStack.f_41583_ && itemStackInSlot1 != ItemStack.f_41583_) {
            if (hasMatchingSet) {
                this.renderSlot(guiGraphics, i, j, 0, Texture.Coords.VOID_SLOT);
                this.renderSlot(guiGraphics, i, j, 1, Texture.Coords.VOID_SLOT);
                this.renderFadeEffect(guiGraphics, i + 63, j + 30, Texture.Coords.PICK);
                this.renderFadeEffect(guiGraphics, i + 89, j + 30, Texture.Coords.SCROLL);
            } else if (hasRepairingSet) {
                this.renderSlot(guiGraphics, i, j, 0, Texture.Coords.VOID_SLOT);
                this.renderSlot(guiGraphics, i, j, 1, Texture.Coords.VOID_SLOT);
                this.renderFadeEffect(guiGraphics, i + 64, j + 17, Texture.Coords.DAMAGED_PICK);
                this.renderFadeEffect(guiGraphics, i + 88, j + 16, Texture.Coords.REPAIR_MATERIAL);
            }
        } else {
            if (itemStackInSlot0 != ItemStack.f_41583_) {
                this.renderConditions(guiGraphics, i, j, hasBasePickaxe, isPickaxeDamaged, hasScroll, hasRepairItem);
            }
            if (itemStackInSlot1 != ItemStack.f_41583_) {
                this.renderConditions(guiGraphics, i, j, hasBasePickaxe, isPickaxeDamaged, hasScroll, hasRepairItem);
            }
        }
        this.renderOutput(guiGraphics, i, j, hasBasePickaxe, isPickaxeDamaged, hasScroll, hasRepairItem, hasMatchingSet, hasRepairingSet);
    }

    private void renderConditions(GuiGraphics guiGraphics, int i, int j, boolean hasBasePickaxe, boolean isPickaxeDamaged, boolean hasScroll, boolean hasRepairItem) {
        if (hasBasePickaxe) {
            this.renderFadeEffect(guiGraphics, i + 63, j + 30, Texture.Coords.PICK);
        }
        if (isPickaxeDamaged) {
            this.renderFadeEffect(guiGraphics, i + 64, j + 17, Texture.Coords.DAMAGED_PICK);
        }
        if (hasScroll) {
            this.renderFadeEffect(guiGraphics, i + 89, j + 30, Texture.Coords.SCROLL);
        }
        if (hasRepairItem) {
            this.renderFadeEffect(guiGraphics, i + 88, j + 16, Texture.Coords.REPAIR_MATERIAL);
        }
    }

    private void renderSlot(GuiGraphics guiGraphics, int i, int j, int slot, Texture.Coords coords) {
        if (((EmeraldAnvilMenu)this.f_97732_).m_38853_(slot).m_6657_()) {
            this.renderDefault(guiGraphics, i + 27 + 49 * slot, j + 47, coords.x, coords.y, coords.width, coords.height);
        }
    }

    private void renderOutput(GuiGraphics guiGraphics, int i, int j, boolean hasBasePickaxe, boolean isPickaxeDamaged, boolean hasScroll, boolean hasRepairItem, boolean hasMatchingSet, boolean hasRepairingSet) {
        if (hasBasePickaxe && hasScroll && hasMatchingSet) {
            this.renderScaleEffect(guiGraphics, i + 111, j + 27, Texture.Coords.COMBINED_OUTPUT);
        } else if (isPickaxeDamaged && hasRepairItem && hasRepairingSet) {
            this.renderScaleEffect(guiGraphics, i + 113, j + 16, Texture.Coords.REPAIRED_OUTPUT);
        } else if ((((EmeraldAnvilMenu)this.f_97732_).m_38853_(0).m_6657_() || ((EmeraldAnvilMenu)this.f_97732_).m_38853_(1).m_6657_()) && !((EmeraldAnvilMenu)this.f_97732_).m_38853_(2).m_6657_()) {
            this.renderDefault(guiGraphics, i + 99, j + 45, this.f_97726_, 0, 28, 21);
        }
    }

    private ItemStack getItemStackInSlot(int slot) {
        return ((EmeraldAnvilMenu)this.f_97732_).m_38853_(slot).m_6657_() ? ((EmeraldAnvilMenu)this.f_97732_).m_38853_(slot).m_7993_() : ItemStack.f_41583_;
    }

    private boolean isBasePickaxe(ItemStack itemStack) {
        return itemStack.m_41720_() == ModItems.EMERALD_PICKAXE.get() || itemStack.m_41720_() == ModItems.AMETHYST_PICKAXE.get() || itemStack.m_41720_() == ModItems.EMPOWERED_IRON_PICKAXE.get();
    }

    private boolean isMatchingSet(ItemStack pickaxe, ItemStack scroll) {
        return pickaxe.m_41720_() == ModItems.EMERALD_PICKAXE.get() && this.isEmeraldScroll(scroll) || pickaxe.m_41720_() == ModItems.AMETHYST_PICKAXE.get() && this.isAmethystScroll(scroll) || pickaxe.m_41720_() == ModItems.EMPOWERED_IRON_PICKAXE.get() && this.isIronScroll(scroll);
    }

    private boolean isMatchingRepair(ItemStack pickaxe, ItemStack repairItem) {
        Map<Item, Boolean> pickaxeChecks = Map.of(Items.f_151049_, this.isAmethystPickaxe(pickaxe), Items.f_42616_, this.isEmeraldPickaxe(pickaxe), Items.f_42110_, this.isEmeraldPickaxe(pickaxe), Items.f_42416_, this.isEmpoweredIronPickaxe(pickaxe), Items.f_41913_, this.isEmpoweredIronPickaxe(pickaxe));
        return pickaxeChecks.getOrDefault(repairItem.m_41720_(), false);
    }

    private boolean isAmethystPickaxe(ItemStack pickaxe) {
        return pickaxe.m_41720_() == ModItems.AMETHYST_PICKAXE.get() || pickaxe.m_41720_() == ModItems.AMETHYST_PICKAXE_LUCK.get() || pickaxe.m_41720_() == ModItems.AMETHYST_PICKAXE_INFECTION.get();
    }

    private boolean isEmeraldPickaxe(ItemStack pickaxe) {
        return pickaxe.m_41720_() == ModItems.EMERALD_PICKAXE.get() || pickaxe.m_41720_() == ModItems.EMERALD_PICKAXE_BUFF.get() || pickaxe.m_41720_() == ModItems.EMERALD_PICKAXE_SPOT.get();
    }

    private boolean isEmpoweredIronPickaxe(ItemStack pickaxe) {
        return pickaxe.m_41720_() == ModItems.EMPOWERED_IRON_PICKAXE.get() || pickaxe.m_41720_() == ModItems.EMPOWERED_IRON_PICKAXE_EXPLOSION.get() || pickaxe.m_41720_() == ModItems.EMPOWERED_IRON_PICKAXE_MAGNET.get();
    }

    private boolean isEmeraldScroll(ItemStack scroll) {
        return scroll.m_41720_() == ModItems.SCROLL_SPOT.get() || scroll.m_41720_() == ModItems.SCROLL_BUFF.get();
    }

    private boolean isAmethystScroll(ItemStack scroll) {
        return scroll.m_41720_() == ModItems.SCROLL_LUCK.get() || scroll.m_41720_() == ModItems.SCROLL_INFECTION.get();
    }

    private boolean isIronScroll(ItemStack scroll) {
        return scroll.m_41720_() == ModItems.SCROLL_MAGNET.get() || scroll.m_41720_() == ModItems.SCROLL_EXPLOSION.get();
    }

    private float getElapsedTime() {
        return (float)(System.currentTimeMillis() - this.startTime) / 1500.0f;
    }

    private void renderDefault(GuiGraphics guiGraphics, int x, int y, int textureX, int textureY, int textureWidth, int textureHeight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.m_280218_(GUI_TEXTURE, x, y, textureX, textureY, textureWidth, textureHeight);
    }

    private void renderFadeEffect(GuiGraphics guiGraphics, int x, int y, Texture.Coords coords) {
        float alpha = 0.5f + 0.5f * (float)Math.sin((double)(this.getElapsedTime() * 2.0f) * Math.PI);
        this.renderWithAlpha(guiGraphics, x, y, coords, alpha);
    }

    private void renderScaleEffect(GuiGraphics guiGraphics, int x, int y, Texture.Coords coords) {
        float scale = 1.0f + 0.1f * (float)Math.sin((double)(this.getElapsedTime() * 2.0f) * Math.PI);
        float alpha = 0.5f + 0.5f * (float)Math.sin((double)(this.getElapsedTime() * 2.0f) * Math.PI);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x + (double)coords.width / 2.0, (double)y + (double)coords.height / 2.0, 0.0);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(-((double)x + (double)coords.width / 2.0), -((double)y + (double)coords.height / 2.0), 0.0);
        guiGraphics.m_280218_(GUI_TEXTURE, x, y, coords.x, coords.y, coords.width, coords.height);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderWithAlpha(GuiGraphics guiGraphics, int x, int y, Texture.Coords coords, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.m_280218_(GUI_TEXTURE, x, y, coords.x, coords.y, coords.width, coords.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    protected void m_266390_(@NotNull GuiGraphics guiGraphics, int x, int y) {
        if ((((EmeraldAnvilMenu)this.f_97732_).m_38853_(0).m_6657_() || ((EmeraldAnvilMenu)this.f_97732_).m_38853_(1).m_6657_()) && !((EmeraldAnvilMenu)this.f_97732_).m_38853_(((EmeraldAnvilMenu)this.f_97732_).m_266562_()).m_6657_()) {
            guiGraphics.m_280218_(GUI_TEXTURE, x + 99, y + 45, this.f_97726_, 0, 28, 21);
        }
    }
}

