/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPacket;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ClientPacketHandlers {
    public static void handle(ClientBoundEntityFellPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(packet.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, packet.y(), packet.distance(), packet.fallDamage(), ClientPacketHandlers.getEntityFellConfig(packet));
        }
    }

    public static void handle(ClientBoundEntitySpawnSprintingDustCloudsPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(packet.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int ySpeedModifier = 5;
            if (livingEntity instanceof Ravager) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (Level)level, livingEntity.m_217043_(), ySpeedModifier);
        }
    }

    public static void handle(ClientBoundSpawnSnoreParticlePacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.m_7106_((ParticleOptions)ModParticles.SNORING.get(), packet.x(), packet.y(), packet.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(ClientBoundBlockDestroyEffectsPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(packet)) {
            BlockPos pos = packet.pos();
            BlockState state = Block.m_49803_((int)packet.stateId());
            SoundType soundType = state.m_60827_();
            level.m_142052_(pos, state);
            level.m_245747_(pos, soundType.m_56775_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f, false);
        }
    }

    public static void handle(ClientBoundXPBottleEffectsPacket packet) {
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockPos pos = packet.pos();
        Vec3 vec3 = Vec3.m_82539_((Vec3i)pos);
        RandomSource random = level.m_213780_();
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.VANILLA) {
            level.m_46796_(2002, pos, PotionUtils.m_43559_((Potion)Potions.f_43599_));
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ENTITIES.xpBottleParticlesDensity.get(); ++i) {
                double d = random.m_188500_() * 4.0;
                double d1 = random.m_188500_() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.m_7106_((ParticleOptions)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.f_82479_ + xPower * 0.1, vec3.f_82480_ + 0.3, vec3.f_82481_ + zPower * 0.1, xPower, 0.01 + random.m_188500_() * 0.5, zPower);
            }
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ModEntityConfigs.XPBottleParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42736_)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, random.m_188583_() * 0.15, random.m_188500_() * 0.2, random.m_188583_() * 0.15);
            }
            level.m_245747_(pos, SoundEvents.f_12436_, SoundSource.NEUTRAL, 1.0f, random.m_188501_() * 0.1f + 0.9f, false);
        }
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPacket packet) {
        return switch (packet.config()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPacket packet) {
        return switch (packet.config()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientBoundEntityFellPacket.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPacket.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPacket.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPacket.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }
}

