/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.spark.common.platform.world.AsyncWorldInfoProvider;
import me.lucko.spark.common.platform.world.ChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.proto.SparkProtos;

public class WorldStatisticsProvider {
    private final AsyncWorldInfoProvider provider;

    public WorldStatisticsProvider(AsyncWorldInfoProvider provider) {
        this.provider = provider;
    }

    public SparkProtos.WorldStatistics getWorldStatistics() {
        WorldInfoProvider.ChunksResult<ChunkInfo<?>> result = this.provider.getChunks();
        if (result == null) {
            return null;
        }
        SparkProtos.WorldStatistics.Builder stats = SparkProtos.WorldStatistics.newBuilder();
        AtomicInteger combinedTotal = new AtomicInteger();
        CountMap.Simple combined = new CountMap.Simple(new HashMap());
        result.getWorlds().forEach((worldName, chunks) -> {
            SparkProtos.WorldStatistics.World.Builder builder = SparkProtos.WorldStatistics.World.newBuilder();
            builder.setName((String)worldName);
            List<Region> regions = WorldStatisticsProvider.groupIntoRegions(chunks);
            int total = 0;
            for (Region region : regions) {
                builder.addRegions(WorldStatisticsProvider.regionToProto(region, combined));
                total += region.getTotalEntities().get();
            }
            builder.setTotalEntities(total);
            combinedTotal.addAndGet(total);
            stats.addWorlds((SparkProtos.WorldStatistics.World)builder.build());
        });
        stats.setTotalEntities(combinedTotal.get());
        combined.asMap().forEach((key, value) -> stats.putEntityCounts((String)key, value.get()));
        return (SparkProtos.WorldStatistics)stats.build();
    }

    private static SparkProtos.WorldStatistics.Region regionToProto(Region region, CountMap<String> combined) {
        SparkProtos.WorldStatistics.Region.Builder builder = SparkProtos.WorldStatistics.Region.newBuilder();
        builder.setTotalEntities(region.getTotalEntities().get());
        for (ChunkInfo<?> chunk : region.getChunks()) {
            builder.addChunks(WorldStatisticsProvider.chunkToProto(chunk, combined));
        }
        return (SparkProtos.WorldStatistics.Region)builder.build();
    }

    private static <E> SparkProtos.WorldStatistics.Chunk chunkToProto(ChunkInfo<E> chunk, CountMap<String> combined) {
        SparkProtos.WorldStatistics.Chunk.Builder builder = SparkProtos.WorldStatistics.Chunk.newBuilder();
        builder.setX(chunk.getX());
        builder.setZ(chunk.getZ());
        builder.setTotalEntities(chunk.getEntityCounts().total().get());
        chunk.getEntityCounts().asMap().forEach((key, value) -> {
            String name = chunk.entityTypeName(key);
            int count = value.get();
            if (name == null) {
                name = "unknown[" + key.toString() + "]";
            }
            builder.putEntityCounts(name, count);
            combined.add(name, count);
        });
        return (SparkProtos.WorldStatistics.Chunk)builder.build();
    }

    private static List<Region> groupIntoRegions(List<? extends ChunkInfo<?>> chunks) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (ChunkInfo<?> chunk : chunks) {
            CountMap<?> counts = chunk.getEntityCounts();
            if (counts.total().get() == 0) continue;
            boolean found = false;
            for (Region region : regions) {
                if (!region.isAdjacent(chunk)) continue;
                found = true;
                region.add(chunk);
                Iterator iterator = regions.iterator();
                while (iterator.hasNext()) {
                    Region otherRegion = (Region)iterator.next();
                    if (region == otherRegion || !otherRegion.isAdjacent(chunk)) continue;
                    iterator.remove();
                    region.merge(otherRegion);
                }
                break block1;
            }
            if (found) continue;
            regions.add(new Region(chunk));
        }
        return regions;
    }

    private static final class Region {
        private static final int DISTANCE_THRESHOLD = 2;
        private final Set<ChunkInfo<?>> chunks = new HashSet();
        private final AtomicInteger totalEntities;

        private Region(ChunkInfo<?> initial) {
            this.chunks.add(initial);
            this.totalEntities = new AtomicInteger(initial.getEntityCounts().total().get());
        }

        public Set<ChunkInfo<?>> getChunks() {
            return this.chunks;
        }

        public AtomicInteger getTotalEntities() {
            return this.totalEntities;
        }

        public boolean isAdjacent(ChunkInfo<?> chunk) {
            for (ChunkInfo<?> el : this.chunks) {
                if (Region.squaredEuclideanDistance(el, chunk) > 2L) continue;
                return true;
            }
            return false;
        }

        public void add(ChunkInfo<?> chunk) {
            this.chunks.add(chunk);
            this.totalEntities.addAndGet(chunk.getEntityCounts().total().get());
        }

        public void merge(Region group) {
            this.chunks.addAll(group.getChunks());
            this.totalEntities.addAndGet(group.getTotalEntities().get());
        }

        private static long squaredEuclideanDistance(ChunkInfo<?> a, ChunkInfo<?> b) {
            long dx = a.getX() - b.getX();
            long dz = a.getZ() - b.getZ();
            return dx * dx + dz * dz;
        }
    }
}

