/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.mus;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class MemoryUsageOverlay {
    public static final ResourceLocation FONT_LOCATION = new ResourceLocation("memoryusagescreen", "fonts");
    private static final Minecraft mc = Minecraft.m_91087_();
    private float maxBar;

    public void render(GuiGraphics guiGraphics, float alpha, boolean useFont, boolean bloackGrond, float delta) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        int colw = FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)255, (int)255, (int)255);
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long usage = total - free;
        float currentUsage = (float)usage / (float)max;
        float currentAllocated = (float)total / (float)max;
        float wringWar = 0.33333334f;
        float cr = (Mth.m_14036_((float)currentUsage, (float)wringWar, (float)(wringWar * 2.0f)) - wringWar) / wringWar;
        float cg = 1.0f - (Mth.m_14036_((float)currentUsage, (float)(wringWar * 2.0f), (float)1.0f) - wringWar * 2.0f) / wringWar;
        int colmem = FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)Math.round(cr * 255.0f), (int)Math.round(cg * 255.0f), (int)0);
        int sw = mc.m_91268_().m_85445_();
        int sh = mc.m_91268_().m_85446_();
        int w = 246;
        int h = 11;
        int sx = sw / 2 - w / 2;
        int sy = (int)((double)sh * 0.08);
        if (currentUsage > this.maxBar) {
            this.maxBar = currentUsage;
        }
        this.renderCenterString("Memory Used / Total", guiGraphics, sw / 2, sy - 10, 1.0f, 1.0f, 1.0f, alpha, useFont);
        if (bloackGrond) {
            this.cfill(guiGraphics, sx, sy, w, h, FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)0, (int)0, (int)0));
        }
        this.cfill(guiGraphics, sx, sy, 1, h, colw);
        this.cfill(guiGraphics, sx + w - 1, sy, 1, h, colw);
        this.cfill(guiGraphics, sx + 1, sy, w - 2, 1, colw);
        this.cfill(guiGraphics, sx + 1, sy + h - 1, w - 2, 1, colw);
        this.cfill(guiGraphics, sx + 2, sy + 2, (int)((float)(w - 4) * currentUsage), h - 4, colmem);
        this.cfill(guiGraphics, sx + 2 + (int)((float)(w - 4) * this.maxBar), sy + 1, 1, h - 2, FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)0, (int)0, (int)255));
        this.cfill(guiGraphics, sx + 2 + (int)((float)(w - 4) * currentAllocated), sy + 1, 1, h - 2, FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)(bloackGrond ? 255 : 0), (int)0, (int)0));
        this.renderCenterString(String.format("%03d/%03dMB", this.bytesToMegabytes(usage), this.bytesToMegabytes(max)), guiGraphics, sw / 2, sy + 2, 1.0f, 1.0f, 1.0f, alpha, useFont);
        poseStack.m_85849_();
    }

    private void cfill(GuiGraphics guiGraphics, int x, int y, int w, int h, int col) {
        guiGraphics.m_280509_(x, y, x + w, y + h, col);
    }

    private void renderCenterString(String str, GuiGraphics guiGraphics, int x, int y, float r, float g, float b, float a, boolean useFont) {
        int size;
        if (!useFont) {
            str = str.toUpperCase();
        }
        int n = size = useFont ? MemoryUsageOverlay.mc.f_91062_.m_92895_(str) : str.length() * 6;
        if (useFont) {
            int col = FastColor.ARGB32.m_13660_((int)Math.round(a * 255.0f), (int)Math.round(r * 255.0f), (int)Math.round(g * 255.0f), (int)Math.round(b * 255.0f));
            guiGraphics.m_280488_(MemoryUsageOverlay.mc.f_91062_, str, (int)((float)x - (float)size / 2.0f), y, col);
        } else {
            this.renderNoFontString(str, guiGraphics, x - size / 2, y, a, r, g, b);
        }
    }

    private void renderNoFontString(String str, GuiGraphics guiGraphics, int x, int y, float alpha, float r, float g, float b) {
        for (int a = 0; a < str.length(); ++a) {
            char ch = str.charAt(a);
            if (ch > '\u00ff') continue;
            int tsx = (ch & 0xF) * 8;
            int tsy = (ch >> 4 & 0xF) * 8;
            this.drawTexture(FONT_LOCATION, guiGraphics, x + a * 6, y, tsx, tsy, 6, 7, 128, 128, r, g, b, alpha);
        }
    }

    private long bytesToMegabytes(long l) {
        return l / 1024L / 1024L;
    }

    private void drawTexture(ResourceLocation location, GuiGraphics guiGraphics, int x, int y, int textureStartX, int textureStartY, int textureFinishWidth, int textureFinishHeight, int textureSizeX, int textureSizeY, float r, float g, float b, float a) {
        PoseStack psstack = guiGraphics.m_280168_();
        psstack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        guiGraphics.m_280246_(r, g, b, a);
        guiGraphics.m_280163_(location, x, y, (float)textureStartX, (float)textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        psstack.m_85849_();
    }

    public void reset() {
        this.maxBar = 0.0f;
    }
}

