/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.cristelknight.doapi.client.render.feature.CustomArmorManager;
import de.cristelknight.doapi.common.item.ICustomArmor;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomArmorFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public final CustomArmorManager<T> ARMORS;

    public CustomArmorFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet modelSet) {
        super(context);
        this.ARMORS = new CustomArmorManager(modelSet);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, EquipmentSlot.CHEST, i);
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, EquipmentSlot.LEGS, i);
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, EquipmentSlot.FEET, i);
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, EquipmentSlot.HEAD, i);
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot slot, int light) {
        ItemStack itemStack = livingEntity.m_6844_(slot);
        Item item = itemStack.m_41720_();
        if (!(item instanceof ICustomArmor)) {
            return;
        }
        ICustomArmor customArmor = (ICustomArmor)item;
        Item item2 = itemStack.m_41720_();
        if (!(item2 instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item2;
        if (armorItem.m_40402_() != slot) {
            return;
        }
        EntityModel<T> model = this.ARMORS.getModel((Item)armorItem, slot);
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ((HumanoidModel)this.m_117386_()).m_102872_(humanoidModel);
            this.setPartVisibility(humanoidModel, slot);
        }
        boolean foil = itemStack.m_41790_();
        poseStack.m_85836_();
        if (slot == EquipmentSlot.HEAD) {
            ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_252880_(0.0f, customArmor.getYOffset().floatValue(), 0.0f);
        if (armorItem instanceof DyeableArmorItem) {
            DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)armorItem;
            int c = dyeableArmorItem.m_41121_(itemStack);
            float r = (float)(c >> 16 & 0xFF) / 255.0f;
            float g = (float)(c >> 8 & 0xFF) / 255.0f;
            float b = (float)(c & 0xFF) / 255.0f;
            this.renderModel(poseStack, multiBufferSource, light, foil, model, r, g, b, this.ARMORS.getTexture((Item)armorItem, null));
            this.renderModel(poseStack, multiBufferSource, light, foil, model, 1.0f, 1.0f, 1.0f, this.ARMORS.getTexture((Item)armorItem, "overlay"));
        } else {
            this.renderModel(poseStack, multiBufferSource, light, foil, model, 1.0f, 1.0f, 1.0f, this.ARMORS.getTexture((Item)armorItem, null));
        }
        poseStack.m_85849_();
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, boolean foil, EntityModel<T> model, float f, float g, float h, ResourceLocation resourceLocation) {
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)resourceLocation), (boolean)false, (boolean)foil);
        model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, f, g, h, 1.0f);
    }

    private void setPartVisibility(HumanoidModel<T> humanoidModel, EquipmentSlot equipmentSlot) {
        humanoidModel.m_8009_(false);
        switch (equipmentSlot) {
            case HEAD: {
                humanoidModel.f_102808_.f_104207_ = true;
                humanoidModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                humanoidModel.f_102810_.f_104207_ = true;
                humanoidModel.f_102811_.f_104207_ = true;
                humanoidModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                humanoidModel.f_102810_.f_104207_ = true;
                humanoidModel.f_102813_.f_104207_ = true;
                humanoidModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                humanoidModel.f_102813_.f_104207_ = true;
                humanoidModel.f_102814_.f_104207_ = true;
            }
        }
    }
}

