/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int fluidAmount;
    private final int craftingDuration;

    public CookingCauldronRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, int fluidAmount, int craftingDuration) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.fluidAmount = fluidAmount;
        this.craftingDuration = craftingDuration;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 0, 6);
    }

    public ItemStack assemble() {
        return this.m_5874_(null, null);
    }

    @NotNull
    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack getResultItem() {
        return this.m_8043_(null);
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getCraftingDuration() {
        return this.craftingDuration;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.COOKING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.COOKING.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Type
    implements RecipeType<CookingCauldronRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "cooking";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<CookingCauldronRecipe> {
        @NotNull
        public CookingCauldronRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> ingredients = GeneralUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for CookingCauldron Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for CookingCauldron Recipe");
            }
            int fluidAmount = GsonHelper.m_13824_((JsonObject)json, (String)"fluid_amount", (int)0);
            int craftingDuration = GsonHelper.m_13824_((JsonObject)json, (String)"crafting_duration", (int)10);
            return new CookingCauldronRecipe(id, ingredients, ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")), fluidAmount, craftingDuration);
        }

        @NotNull
        public CookingCauldronRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            int fluidAmount = buf.readInt();
            int craftingDuration = buf.readInt();
            return new CookingCauldronRecipe(id, (NonNullList<Ingredient>)ingredients, output, fluidAmount, craftingDuration);
        }

        public void toNetwork(FriendlyByteBuf buf, CookingCauldronRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(buf));
            buf.m_130055_(recipe.output);
            buf.writeInt(recipe.fluidAmount);
            buf.writeInt(recipe.craftingDuration);
        }
    }
}

