/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.customterrain;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.util.BlendUtil;

public class CragGardenExtension {
    public static void runCragGardenExtension(Function<BlockPos, Holder<Biome>> biomeGetter, ChunkAccess chunk, long worldSeed, NormalNoise.NoiseParameters noiseParameters, NormalNoise.NoiseParameters cliffSpacingParams) {
        ChunkPos pos = chunk.m_7697_();
        XoroshiroRandomSource randomSource = new XoroshiroRandomSource(worldSeed);
        XoroshiroRandomSource chunkRandom = new XoroshiroRandomSource(pos.m_45588_() + worldSeed);
        NormalNoise normalNoise = NormalNoise.m_230511_((RandomSource)randomSource, (NormalNoise.NoiseParameters)noiseParameters);
        NormalNoise cliffJumpNoise = NormalNoise.m_230511_((RandomSource)randomSource, (NormalNoise.NoiseParameters)cliffSpacingParams);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        WeightedStateProvider topBlocksProvider = new WeightedStateProvider(new SimpleWeightedRandomList.Builder().m_146271_((Object)BWGBlocks.OVERGROWN_STONE.get().m_49966_(), 3).m_146271_((Object)Blocks.f_152544_.m_49966_(), 1));
        WeightedStateProvider stonesProvider = new WeightedStateProvider(new SimpleWeightedRandomList.Builder().m_146271_((Object)Blocks.f_50069_.m_49966_(), 1).m_146271_((Object)Blocks.f_50334_.m_49966_(), 1).m_146271_((Object)BWGBlocks.ROCKY_STONE_SET.getBase().m_49966_(), 1));
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = pos.m_151382_(x);
                int worldZ = pos.m_151391_(z);
                int landHeight = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, worldX, worldZ) / 10 * 10;
                if (chunk.m_141937_() >= landHeight) continue;
                mutable.m_122178_(worldX, landHeight, worldZ);
                Holder<Biome> currentBiome = biomeGetter.apply((BlockPos)mutable);
                if (!currentBiome.m_203565_(BWGBiomes.CRAG_GARDENS)) continue;
                double normalizedCliffNoise = cliffJumpNoise.m_75380_((double)worldX * 0.05, 0.0, (double)worldZ * 0.05) + 0.5;
                int cliffJumpNoiseOffset = Mth.m_14107_((double)(normalizedCliffNoise * 10.0));
                double blendRadius = BlendUtil.blendBiomeEdge(currentBiome, biomeGetter, (BlockPos)mutable, 16, 1);
                int currentSurfaceHeight = (int)((double)CragGardenExtension.getSurfaceHeight(normalNoise, worldX, worldZ, Math.max(10, cliffJumpNoiseOffset * 2)) * blendRadius);
                for (int y = -5; y <= currentSurfaceHeight; ++y) {
                    mutable.m_122178_(worldX, y + landHeight, worldZ);
                    BlockState state = stonesProvider.m_213972_((RandomSource)chunkRandom, (BlockPos)mutable);
                    if (y == currentSurfaceHeight && chunk.m_8055_((BlockPos)mutable.m_122173_(Direction.UP)).m_60819_().m_76178_()) {
                        state = topBlocksProvider.m_213972_((RandomSource)chunkRandom, (BlockPos)mutable);
                        mutable.m_122173_(Direction.DOWN);
                    }
                    chunk.m_6978_((BlockPos)mutable, state, false);
                }
            }
        }
    }

    private static int getSurfaceHeight(NormalNoise normalNoise, int worldX, int worldZ, int spacing) {
        double normalizedNoise = (normalNoise.m_75380_((double)worldX * 0.005, 0.0, (double)worldZ * 0.005) + 1.0) * 0.5;
        return Mth.m_14107_((double)(normalizedNoise * 50.0)) / spacing * spacing;
    }
}

