/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ScarfOfInvisibilityItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"invisible").stat(StatData.builder((String)"time").initialValue(140.0, 100.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> MathUtils.round((double)(value / 20.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-11426593).borderBottom(-13878416).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.END).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        if (!(entity instanceof Player) || (player = (Player)entity).m_20193_().m_5776_() || !this.canUseAbility(stack, "invisible")) {
            return;
        }
        int time = this.getTime(stack);
        if (time == 0 && player.m_20193_().m_45976_(Mob.class, player.m_20191_().m_82400_(15.0)).stream().noneMatch(mob -> mob.m_5448_() == player)) {
            if (!player.m_21023_((MobEffect)EffectRegistry.VANISHING.get())) {
                this.spreadExperience((LivingEntity)player, stack, 1);
            }
            player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 4, 0, true, false));
        } else if (time > 0) {
            this.addTime(stack, -1);
        }
    }

    public void addTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) + time);
    }

    public void setTime(ItemStack stack, int time) {
        NBTUtils.setInt((ItemStack)stack, (String)"time", (int)Math.max(time, 0));
    }

    public int getTime(ItemStack stack) {
        return NBTUtils.getInt((ItemStack)stack, (String)"time", (int)0);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class ScarfOfInvisibilityClientEvent {
        @SubscribeEvent
        public static void onRenderHand(RenderHandEvent event) {
            ScarfOfInvisibilityItem relic;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.SCARF_OF_INVISIBILITY.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof ScarfOfInvisibilityItem) || !(relic = (ScarfOfInvisibilityItem)item).canUseAbility(stack, "invisible")) {
                return;
            }
            if (player.m_21023_((MobEffect)EffectRegistry.VANISHING.get())) {
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class ScarfOfInvisibilityEvent {
        @SubscribeEvent
        public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            ScarfOfInvisibilityEvent.onInteract(event.getEntity());
        }

        @SubscribeEvent
        public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
            ScarfOfInvisibilityEvent.onInteract(event.getEntity());
        }

        @SubscribeEvent
        public static void onHarvestCheck(PlayerEvent.BreakSpeed event) {
            ScarfOfInvisibilityEvent.onInteract(event.getEntity());
        }

        @SubscribeEvent
        public static void onAttacking(AttackEntityEvent event) {
            ScarfOfInvisibilityEvent.onInteract(event.getEntity());
        }

        private static void onInteract(Player player) {
            if (player.m_20193_().m_5776_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.SCARF_OF_INVISIBILITY.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof ScarfOfInvisibilityItem)) {
                return;
            }
            ScarfOfInvisibilityItem relic = (ScarfOfInvisibilityItem)item;
            relic.setTime(stack, (int)relic.getAbilityValue(stack, "invisible", "time"));
        }
    }
}

