/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import party.lemons.biomemakeover.util.extension.Stuntable;

@Mixin(value={AgeableMob.class})
public abstract class AgeableMobMixin_Stuntable
extends PathfinderMob
implements Stuntable {
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> f_146731_;
    @Shadow
    protected int f_146733_;
    private boolean isStunted = false;

    @Inject(at={@At(value="HEAD")}, method={"isBaby"}, cancellable=true)
    private void isBaby(CallbackInfoReturnable<Boolean> cbi) {
        if (this.isStunted()) {
            cbi.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void addAdditionalData(CompoundTag tag, CallbackInfo cbi) {
        tag.m_128379_("bm_IsStunted", this.isStunted());
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void readAdditionalData(CompoundTag tag, CallbackInfo cbi) {
        if (tag.m_128441_("bm_IsStunted")) {
            this.setStunted(tag.m_128471_("bm_IsStunted"));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getAge"}, cancellable=true)
    public void getAge(CallbackInfoReturnable<Integer> cbi) {
        if (this.isStunted()) {
            cbi.setReturnValue((Object)-6000);
            this.m_20088_().m_135381_(f_146731_, (Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setAge"}, cancellable=true)
    public void setAge(int age, CallbackInfo cbi) {
        if (this.isStunted()) {
            this.f_146733_ = -6000;
            this.m_20088_().m_135381_(f_146731_, (Object)true);
            cbi.cancel();
        }
    }

    @Override
    public boolean isStunted() {
        return this.isStunted;
    }

    @Override
    public void setStunted(boolean stunted) {
        this.isStunted = stunted;
        if (this.isStunted) {
            this.m_20088_().m_135381_(f_146731_, (Object)true);
        }
    }

    protected AgeableMobMixin_Stuntable(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }
}

