/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion.room;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import party.lemons.biomemakeover.level.feature.mansion.LayoutType;
import party.lemons.biomemakeover.level.feature.mansion.MansionDetails;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.MansionTemplateType;
import party.lemons.biomemakeover.level.feature.mansion.MansionTemplates;
import party.lemons.biomemakeover.level.feature.mansion.RoomLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.taniwha.util.MathUtils;
import party.lemons.taniwha.util.collections.Grid;

public class MansionRoom {
    protected final RoomLayout layout = new RoomLayout();
    protected final BlockPos position;
    protected RoomType type;
    protected LayoutType layoutType;
    public boolean active = true;
    private int sortValue = 0;

    public MansionRoom(BlockPos position, RoomType type) {
        this.position = position;
        this.type = type;
        this.layoutType = LayoutType.NORMAL;
    }

    public RoomType getRoomType() {
        return this.type;
    }

    public void setRoomType(RoomType type) {
        this.type = type;
    }

    public void setLayout(MansionLayout layout, RandomSource random) {
        Grid<MansionRoom> lo = layout.getLayout();
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            MansionRoom neighbour = (MansionRoom)lo.get(this.getPosition().m_121945_(dir));
            if (neighbour == null) continue;
            switch (this.layoutType) {
                case REQUIRED: {
                    this.layout.put(dir, true);
                    neighbour.layout.put(dir.m_122424_(), true);
                }
            }
        }
    }

    public RoomLayout getLayout() {
        return this.layout;
    }

    public void setLayoutType(LayoutType layoutType) {
        this.layoutType = layoutType;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public ResourceLocation getTemplate(MansionTemplates templates, RandomSource random) {
        if (this.type != RoomType.CORRIDOR) {
            return this.type.getRandomTemplate(templates, this.position, random);
        }
        List<ResourceLocation> ids = switch (this.layout.doorCount()) {
            case 1 -> MansionTemplateType.CORRIDOR_STRAIGHT.getTemplates(templates);
            case 2 -> {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() || ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    yield MansionTemplateType.CORRIDOR_STRAIGHT.getTemplates(templates);
                }
                yield MansionTemplateType.CORRIDOR_CORNER.getTemplates(templates);
            }
            case 3 -> MansionTemplateType.CORRIDOR_T.getTemplates(templates);
            case 4 -> MansionTemplateType.CORRIDOR_CROSS.getTemplates(templates);
            default -> MansionTemplateType.STAIR_DOWN.getTemplates(templates);
        };
        return ids.get(random.m_188503_(ids.size()));
    }

    public Rotation getRotation(RandomSource random) {
        if (this.type.hasColumnRotation()) {
            int index = Math.abs((this.getPosition().m_123341_() + this.getPosition().m_123343_()) % 4);
            return Rotation.values()[index];
        }
        if (this.type == RoomType.GARDEN) {
            return Rotation.m_221990_((RandomSource)random);
        }
        if (this.type != RoomType.CORRIDOR) {
            return Rotation.m_221990_((RandomSource)random);
        }
        switch (this.layout.doorCount()) {
            case 1: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
            }
            case 2: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
            }
            case 3: {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
            }
            case 4: {
                return Rotation.values()[random.m_188503_(Rotation.values().length)];
            }
            case 0: {
                return Rotation.NONE;
            }
        }
        return null;
    }

    public BlockPos getOffsetForRotation(BlockPos offsetPos, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return offsetPos;
            }
            case CLOCKWISE_90: {
                return offsetPos.m_7918_(10, 0, 0);
            }
            case CLOCKWISE_180: {
                return offsetPos.m_7918_(10, 0, 10);
            }
            case COUNTERCLOCKWISE_90: {
                return offsetPos.m_7918_(0, 0, 10);
            }
        }
        return offsetPos;
    }

    public boolean isConnected(Direction direction) {
        return (Boolean)this.layout.get(direction);
    }

    public boolean canSupportRoof() {
        return true;
    }

    public void setSortValue(int sortValue) {
        this.sortValue = sortValue;
    }

    public int getSortValue() {
        return this.sortValue;
    }

    public boolean hasGroundModifications() {
        return this.getPosition().m_123342_() == 0;
    }

    public void addWalls(MansionDetails details, MansionTemplates templates, RandomSource random, BlockPos wallPos, StructureTemplateManager manager, Grid<MansionRoom> roomGrid, StructurePiecesBuilder children) {
        boolean ground = this.hasGroundModifications();
        if (this.getRoomType().hasWalls()) {
            BlockPos cornerPos1;
            if (this.isConnected(Direction.NORTH)) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getInnerWall(templates, random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground, false));
            } else if (!roomGrid.contains(this.getPosition().m_122012_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122012_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.NORTH, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11), Rotation.CLOCKWISE_180, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_122012_())) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getFlatWall(templates, random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground, false));
            }
            if (this.isConnected(Direction.WEST)) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getInnerWall(templates, random), wallPos, Rotation.CLOCKWISE_90, ground, false));
            } else if (!roomGrid.contains(this.getPosition().m_122024_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122024_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.WEST, roomGrid, random), wallPos.m_122012_(), Rotation.CLOCKWISE_90, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_122024_())) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getFlatWall(templates, random), wallPos, Rotation.CLOCKWISE_90, ground, false));
            }
            if (!roomGrid.contains(this.getPosition().m_122029_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122029_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.EAST, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11).m_122024_().m_122020_(11), Rotation.COUNTERCLOCKWISE_90, ground, true));
            }
            if (!roomGrid.contains(this.getPosition().m_122019_()) || !((MansionRoom)roomGrid.get(this.getPosition().m_122019_())).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getOuterWall(templates, Direction.SOUTH, roomGrid, random), wallPos.m_5484_(Direction.SOUTH, 10).m_122024_(), Rotation.NONE, ground, true));
            }
            if (roomGrid.contains(cornerPos1 = this.getPosition().m_121945_(Direction.NORTH).m_121945_(Direction.WEST)) && ((MansionRoom)roomGrid.get(cornerPos1)).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, MansionTemplateType.CORNER_FILLERS.getRandomTemplate(templates, random).toString(), wallPos.m_121945_(Direction.WEST).m_121945_(Direction.NORTH).m_7918_(0, 0, 0), Rotation.NONE, ground, false));
            }
        }
    }

    public String getInnerWall(MansionTemplates templates, RandomSource random) {
        return MansionTemplateType.INNER_WALL.getRandomTemplate(templates, random).toString();
    }

    public String getFlatWall(MansionTemplates templates, RandomSource random) {
        return MansionTemplateType.FLAT_WALL.getRandomTemplate(templates, random).toString();
    }

    public String getOuterWall(MansionTemplates templates, Direction dir, Grid<MansionRoom> roomGrid, RandomSource random) {
        if (this.getPosition().m_123342_() > 0) {
            if (this.getRoomType().hasWindows() && random.m_188501_() < 0.95f && !roomGrid.contains(this.getPosition().m_121945_(dir))) {
                return MansionTemplateType.OUTER_WINDOW.getRandomTemplate(templates, random).toString();
            }
            return MansionTemplateType.OUTER_WALL.getRandomTemplate(templates, random).toString();
        }
        return MansionTemplateType.OUTER_WALL_BASE.getRandomTemplate(templates, random).toString();
    }

    public void setLayout(MansionRoom currentRoom) {
        for (Direction direction : MathUtils.HORIZONTALS) {
            this.getLayout().put(direction, (Boolean)currentRoom.getLayout().get(direction));
        }
    }
}

