/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import party.lemons.biomemakeover.block.AbstractTapestryBlock;
import party.lemons.biomemakeover.block.AbstractTapestryWallBlock;
import party.lemons.biomemakeover.block.IvyBlock;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMStructures;
import party.lemons.biomemakeover.level.feature.mansion.MansionDetails;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.MansionTemplates;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.util.DirectionalDataHandler;
import party.lemons.biomemakeover.util.extension.Stuntable;
import party.lemons.taniwha.block.WoodBlockFactory;
import party.lemons.taniwha.util.collections.Grid;

public class MansionFeature
extends Structure {
    public static final Codec<MansionFeature> CODEC = RecordCodecBuilder.create(i -> i.group((App)MansionFeature.m_226567_((RecordCodecBuilder.Instance)i), (App)MansionTemplates.CODEC.fieldOf("templates").forGetter(m -> m.templates), (App)MansionDetails.CODEC.fieldOf("details").forGetter(m -> m.details)).apply((Applicative)i, MansionFeature::new));
    public static final BlockIgnoreProcessor IGNORE_AIR_AND_STRUCTURE_BLOCKS = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50016_, (Object)Blocks.f_50677_, (Object)((Block)BMBlocks.DIRECTIONAL_DATA.get())));
    public static final BlockIgnoreProcessor IGNORE_STRUCTURE_BLOCKS = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50677_, (Object)((Block)BMBlocks.DIRECTIONAL_DATA.get())));
    private final MansionTemplates templates;
    private final MansionDetails details;
    private static final BlockState[] SHROOMS = new BlockState[]{Blocks.f_50073_.m_49966_(), Blocks.f_50072_.m_49966_(), ((Block)BMBlocks.WILD_MUSHROOMS.get()).m_49966_()};

    public MansionFeature(Structure.StructureSettings structureSettings, MansionTemplates templates, MansionDetails details) {
        super(structureSettings);
        this.templates = templates;
        this.details = details;
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
        StructurePiecesBuilder builder = new StructurePiecesBuilder();
        MansionLayout layout = new MansionLayout();
        ChunkPos chunkPos = ctx.f_226628_();
        ChunkGenerator chunkGenerator = ctx.f_226622_();
        LevelHeightAccessor levelHeightAccessor = ctx.f_226629_();
        WorldgenRandom random = ctx.f_226626_();
        int x = chunkPos.f_45578_ * 16;
        int z = chunkPos.f_45579_ * 16;
        BlockPos pos = new BlockPos(x, chunkGenerator.m_214096_(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, ctx.f_226624_()), z);
        layout.generateLayout((RandomSource)random, pos.m_123342_());
        Grid<MansionRoom> roomGrid = layout.getLayout();
        Collection sortedRooms = roomGrid.getEntries();
        sortedRooms = sortedRooms.stream().sorted(Comparator.comparingInt(MansionRoom::getSortValue)).collect(Collectors.toList());
        sortedRooms.forEach(arg_0 -> this.lambda$findGenerationPoint$3(pos, (RandomSource)random, builder, ctx, roomGrid, arg_0));
        return Optional.of(new Structure.GenerationStub(this.m_226582_(ctx, Rotation.NONE), Either.right((Object)builder)));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BMStructures.MANSION.get();
    }

    private /* synthetic */ void lambda$findGenerationPoint$3(BlockPos pos, RandomSource random, StructurePiecesBuilder builder, Structure.GenerationContext ctx, Grid roomGrid, MansionRoom rm) {
        int xx = pos.m_123341_() + rm.getPosition().m_123341_() * 12;
        int yy = pos.m_123342_() + rm.getPosition().m_123342_() * 7;
        int zz = pos.m_123343_() + rm.getPosition().m_123343_() * 12;
        BlockPos offsetPos = new BlockPos(xx, yy, zz);
        Rotation rotation = rm.getRotation(random);
        offsetPos = rm.getOffsetForRotation(offsetPos, rotation);
        boolean ground = rm.getPosition().m_123342_() == 0;
        ResourceLocation template = rm.getTemplate(this.templates, random);
        builder.m_142679_((StructurePiece)new Piece(this.details, ctx.f_226625_(), template.toString(), offsetPos, rotation, ground, rm.getRoomType() == RoomType.TOWER_MID || rm.getRoomType() == RoomType.TOWER_TOP));
        BlockPos wallPos = new BlockPos(xx, yy, zz);
        rm.addWalls(this.details, this.templates, random, wallPos, ctx.f_226625_(), (Grid<MansionRoom>)roomGrid, builder);
    }

    public static class Piece
    extends TemplateStructurePiece
    implements DirectionalDataHandler {
        private final boolean ground;
        private final boolean isWall;
        private final MansionDetails details;

        public Piece(MansionDetails details, StructureTemplateManager structureManager, String string, BlockPos blockPos, Rotation rotation, boolean needsGroundAdjustment, boolean isWall) {
            super((StructurePieceType)BMStructures.MANSION_PIECE.get(), 0, structureManager, new ResourceLocation(string), string, Piece.makeSettings(rotation, isWall), blockPos);
            this.ground = needsGroundAdjustment;
            this.isWall = isWall;
            this.details = details;
        }

        public Piece(StructureTemplateManager structureManager, CompoundTag compoundTag) {
            super((StructurePieceType)BMStructures.MANSION_PIECE.get(), compoundTag, structureManager, resourceLocation -> Piece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("Rotation")), compoundTag.m_128471_("IsWall")));
            this.ground = compoundTag.m_128471_("Ground");
            this.isWall = compoundTag.m_128471_("IsWall");
            DataResult detailResult = MansionDetails.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("Details"));
            this.details = detailResult.result().isPresent() ? (MansionDetails)((Pair)detailResult.result().get()).getFirst() : null;
        }

        public Piece(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
            this(ctx.f_226956_(), compoundTag);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, boolean isWall) {
            return new StructurePlaceSettings().m_74392_(true).m_163782_(false).m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)(isWall ? IGNORE_AIR_AND_STRUCTURE_BLOCKS : IGNORE_STRUCTURE_BLOCKS));
        }

        protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
            Either detailsEncode;
            super.m_183620_(structurePieceSerializationContext, compoundTag);
            compoundTag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
            compoundTag.m_128379_("Ground", this.ground);
            compoundTag.m_128379_("IsWall", this.isWall);
            if (this.details != null && (detailsEncode = MansionDetails.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.details).get()).left().isPresent()) {
                compoundTag.m_128365_("Details", (Tag)detailsEncode.left().get());
            }
        }

        protected void m_213704_(String metadata, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox boundingBox) {
            if (metadata.equals("boss")) {
                this.spawnBoss(level, pos);
            } else if (metadata.equals("arena_pos")) {
                level.m_7731_(pos, Blocks.f_50472_.m_49966_(), 2);
            }
        }

        private void spawnBoss(ServerLevelAccessor level, BlockPos pos) {
            AdjudicatorEntity boss = (AdjudicatorEntity)((EntityType)BMEntities.ADJUDICATOR.get()).m_20615_((Level)level.m_6018_());
            boss.m_21530_();
            boss.m_20035_(pos, 0.0f, 0.0f);
            boss.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            level.m_47205_((Entity)boss);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        }

        @Override
        public void handleDirectionalMetadata(String meta, Direction dir, BlockPos pos, WorldGenLevel world, RandomSource random) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            BlockPos offsetPos = pos.m_121945_(dir);
            BlockState offsetState = world.m_8055_(offsetPos);
            switch (meta) {
                case "ivy": {
                    this.generateIvy(dir, pos, world, random);
                    break;
                }
                case "tapestry": {
                    this.generateTapestry(dir, pos, world, random);
                    break;
                }
                case "bonemeal": {
                    break;
                }
                case "spawner_spiders": {
                    BlockEntity be;
                    if (offsetState.m_60734_() != Blocks.f_50085_ || !((be = world.m_7702_(offsetPos)) instanceof SpawnerBlockEntity)) break;
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)be;
                    spawner.m_252803_(random.m_188499_() ? EntityType.f_20554_ : EntityType.f_20479_, random);
                    be.m_6596_();
                    break;
                }
                case "owl": {
                    OwlEntity e = (OwlEntity)((EntityType)BMEntities.OWL.get()).m_20615_((Level)world.m_6018_());
                    e.m_20035_(pos, 0.0f, 0.0f);
                    if (random.m_188501_() < 0.25f) {
                        Stuntable.setStunted((AgeableMob)e, true);
                    }
                    world.m_47205_((Entity)e);
                    break;
                }
                case "shroom": {
                    world.m_7731_(pos, SHROOMS[random.m_188503_(SHROOMS.length)], 3);
                }
            }
            if (meta.startsWith("loot")) {
                if (this.details == null) {
                    return;
                }
                String[] splits = meta.split("_");
                String table = splits[1];
                int chance = splits.length < 3 ? 100 : Integer.parseInt(splits[2]);
                BlockState setState = null;
                if (splits.length >= 4) {
                    StringBuilder name = new StringBuilder();
                    for (int i = 3; i < splits.length; ++i) {
                        name.append(splits[i]).append("_");
                    }
                    setState = ((Block)((Registry)world.m_9598_().m_6632_(Registries.f_256747_).get()).m_7745_(new ResourceLocation(name.substring(0, name.length() - 1)))).m_49966_();
                }
                if (random.m_188503_(100) <= chance) {
                    ResourceLocation tableID = null;
                    switch (table) {
                        case "arrow": {
                            tableID = this.details.loot().arrow();
                            break;
                        }
                        case "dungeonjunk": {
                            tableID = this.details.loot().dungeon_junk();
                            break;
                        }
                        case "dungeon": {
                            tableID = this.details.loot().dungeon_standard();
                            break;
                        }
                        case "dungeongood": {
                            tableID = this.details.loot().dungeonGood();
                            break;
                        }
                        case "junk": {
                            tableID = this.details.loot().junk();
                            break;
                        }
                        case "standard": 
                        case "common": {
                            tableID = this.details.loot().standard();
                            break;
                        }
                        case "loot_good": 
                        case "good": {
                            tableID = this.details.loot().good();
                            break;
                        }
                        default: {
                            System.out.println(table);
                        }
                    }
                    BlockEntity be = world.m_7702_(offsetPos);
                    if (be instanceof RandomizableContainerBlockEntity) {
                        RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)be;
                        container.m_59626_(tableID, random.m_188505_());
                    }
                } else {
                    world.m_7731_(offsetPos, Blocks.f_50016_.m_49966_(), 3);
                }
                if (setState != null) {
                    world.m_7731_(pos, setState, 3);
                }
            } else if (meta.startsWith("enemy")) {
                if (this.details != null) {
                    this.handleSpawning(meta, world, pos, this.details.mobs().enemies());
                }
            } else if (meta.startsWith("ranger")) {
                if (this.details != null) {
                    this.handleSpawning(meta, world, pos, this.details.mobs().ranged_enemies());
                }
            } else if (meta.startsWith("golem")) {
                if (this.details != null) {
                    this.handleSpawning(meta, world, pos, this.details.mobs().golem_enemies());
                }
            } else if (meta.startsWith("ravager")) {
                if (this.details != null) {
                    this.handleSpawning(meta, world, pos, this.details.mobs().ravagers());
                }
            } else if (meta.startsWith("cow")) {
                if (this.details != null) {
                    this.handleSpawning(meta, world, pos, this.details.mobs().cow());
                }
            } else if (meta.startsWith("allay")) {
                for (int i = 0; i < 3; ++i) {
                    if (this.details == null) continue;
                    this.handleSpawning(meta, world, pos, this.details.mobs().allays());
                }
            }
        }

        private void handleSpawning(String meta, WorldGenLevel world, BlockPos pos, List<EntityType<?>> pool) {
            int chance;
            RandomSource random = world.m_213780_();
            String[] splits = meta.split("_");
            if (splits.length < 2) {
                chance = 100;
            } else {
                chance = Integer.parseInt(splits[1]);
                chance /= 2;
            }
            if (world.m_213780_().m_188503_(100) <= chance) {
                EntityType<?> type = pool.get(random.m_188503_(pool.size()));
                Entity e = type.m_20615_((Level)world.m_6018_());
                if (e == null) {
                    return;
                }
                e.m_20035_(pos, 0.0f, 0.0f);
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                    mob.m_21530_();
                }
                world.m_47205_(e);
            }
        }

        private void doBonemealEffect(WorldGenLevel level, BlockPos pos, Random random) {
            BlockPos blockPos = pos.m_7494_();
            BlockState blockState = Blocks.f_50034_.m_49966_();
        }

        private void generateTapestry(Direction dir, BlockPos pos, WorldGenLevel world, RandomSource random) {
            if (dir == Direction.DOWN || dir == Direction.UP) {
                List<RegistrySupplier<Block>> floorBlockSuppliers = BMBlocks.TAPESTRIES.getFloorBlocks();
                Block tapestryBlock = (Block)floorBlockSuppliers.get(random.m_188503_(floorBlockSuppliers.size())).get();
                world.m_7731_(pos, (BlockState)tapestryBlock.m_49966_().m_61124_((Property)AbstractTapestryBlock.ROTATION, (Comparable)Integer.valueOf(Rotation.m_221990_((RandomSource)random).ordinal())), 3);
            } else {
                List<RegistrySupplier<Block>> wallBlockSuppliers = BMBlocks.TAPESTRIES.getWallBlocks();
                Block tapestryBlock = (Block)wallBlockSuppliers.get(random.m_188503_(wallBlockSuppliers.size())).get();
                world.m_7731_(pos, (BlockState)tapestryBlock.m_49966_().m_61124_((Property)AbstractTapestryWallBlock.FACING, (Comparable)dir.m_122424_()), 3);
            }
        }

        private void generateIvy(Direction dir, BlockPos pos, WorldGenLevel world, RandomSource random) {
            BlockPos endPos;
            BlockPos startPos;
            if (random.m_188501_() < 0.25f) {
                return;
            }
            BlockPos topPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos.m_5484_(dir.m_122424_(), 2)).m_7495_();
            BlockState topState = world.m_8055_(topPos);
            if (topState.m_60713_((Block)BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodBlockFactory.Type.SLAB).get()) || topState.m_60713_((Block)BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodBlockFactory.Type.STAIR).get())) {
                return;
            }
            int size = 3;
            if (dir.m_122430_() == 0) {
                Direction rot1 = dir.m_122427_();
                Direction rot2 = dir.m_122428_();
                startPos = pos.m_5484_(rot1, size).m_5484_(Direction.UP, size);
                endPos = pos.m_5484_(rot2, size).m_5484_(Direction.DOWN, size);
            } else {
                startPos = pos.m_7918_(-size, 0, -size);
                endPos = pos.m_7918_(size, 0, size);
            }
            BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos).forEach(p -> {
                BlockPos onPos;
                BlockState onState;
                BlockState currentState = world.m_8055_(p);
                if (random.m_188501_() <= 0.25f && (currentState.m_60795_() || currentState.m_60713_((Block)BMBlocks.IVY.get())) && (onState = world.m_8055_(onPos = p.m_121945_(dir))).m_60783_((BlockGetter)world, onPos, dir.m_122424_())) {
                    if (currentState.m_60713_((Block)BMBlocks.IVY.get())) {
                        world.m_7731_(p, (BlockState)currentState.m_61124_((Property)IvyBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(true)), 3);
                    } else {
                        world.m_7731_(p, (BlockState)((Block)BMBlocks.IVY.get()).m_49966_().m_61124_((Property)IvyBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(true)), 3);
                    }
                }
            });
        }

        public boolean doesModifyGround() {
            return this.ground;
        }
    }
}

