/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.foliage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import party.lemons.biomemakeover.init.BMFeatures;
import party.lemons.taniwha.util.HorizontalDirection;

public class CypressTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CypressTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CypressTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CypressTrunkPlacer::new));

    public CypressTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)BMFeatures.CYPRESS_TRUNK.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource random, int trunkHeight, BlockPos pos, TreeConfiguration treeConfiguration) {
        int i;
        CypressTrunkPlacer.m_226169_((LevelSimulatedReader)level, biConsumer, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)treeConfiguration);
        ArrayList list = Lists.newArrayList();
        for (i = 0; i < trunkHeight; ++i) {
            this.m_226187_(level, biConsumer, random, pos.m_6630_(i), treeConfiguration);
        }
        list.add(new FoliagePlacer.FoliageAttachment(pos.m_6630_(trunkHeight), 1, true));
        for (i = 0; i < 2 + random.m_188503_(6); ++i) {
            HorizontalDirection dir = HorizontalDirection.random((RandomSource)random);
            BlockPos offsetStart = dir.offset(pos);
            for (int j = 0; j < 1 + random.m_188503_(8); ++j) {
                this.m_226187_(level, biConsumer, random, offsetStart.m_6630_(j), treeConfiguration);
            }
        }
        for (i = 0; i < 1 + random.m_188503_(4); ++i) {
            int offset = 7 + random.m_188503_(Math.max(1, trunkHeight - 4));
            Direction dir = Direction.m_235672_((RandomSource)random);
            BlockPos trunkPos = pos.m_121945_(dir).m_6630_(offset);
            this.setBranch(level, biConsumer, treeConfiguration, random, trunkPos);
            list.add(new FoliagePlacer.FoliageAttachment(trunkPos.m_121945_(dir), 1, false));
        }
        return list;
    }

    protected boolean setBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, TreeConfiguration treeConfiguration, RandomSource random, BlockPos blockPos) {
        if (TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)blockPos)) {
            this.m_226187_(level, biConsumer, random, blockPos, treeConfiguration);
            return true;
        }
        return false;
    }
}

