/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.foliage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import party.lemons.biomemakeover.init.BMFeatures;
import party.lemons.taniwha.util.HorizontalDirection;

public class AncientOakTrunkPlacer
extends TrunkPlacer {
    public static final Codec<AncientOakTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> AncientOakTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, AncientOakTrunkPlacer::new));

    public AncientOakTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)BMFeatures.ANCIENT_OAK_TRUNK.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource random, int trunkHeight, BlockPos pos, TreeConfiguration treeConfiguration) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockPos = pos.m_7495_();
        AncientOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, biConsumer, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)treeConfiguration);
        AncientOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, biConsumer, (RandomSource)random, (BlockPos)blockPos.m_122029_(), (TreeConfiguration)treeConfiguration);
        AncientOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, biConsumer, (RandomSource)random, (BlockPos)blockPos.m_122019_(), (TreeConfiguration)treeConfiguration);
        AncientOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, biConsumer, (RandomSource)random, (BlockPos)blockPos.m_122019_().m_122029_(), (TreeConfiguration)treeConfiguration);
        int knobSpot = Math.max(5, trunkHeight / 2 - random.m_188503_(4));
        boolean knobCount = true;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int foliageX = x;
        int foliageZ = z;
        int foliageY = y + trunkHeight - 2;
        for (int genY = 0; genY < trunkHeight; ++genY) {
            int placeY = y + genY;
            BlockPos placePos = new BlockPos(foliageX, placeY, foliageZ);
            if (!TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)placePos)) continue;
            this.m_226187_(level, biConsumer, random, placePos, treeConfiguration);
            this.m_226187_(level, biConsumer, random, placePos.m_122029_(), treeConfiguration);
            this.m_226187_(level, biConsumer, random, placePos.m_122019_(), treeConfiguration);
            this.m_226187_(level, biConsumer, random, placePos.m_122029_().m_122019_(), treeConfiguration);
        }
        list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(foliageX, foliageY + 3, foliageZ), 2, true));
        for (int offsetX = -1; offsetX <= 2; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 2; ++offsetZ) {
                if (offsetX >= 0 && offsetX <= 1 && offsetZ >= 0 && offsetZ <= 1 || random.m_188503_(3) > 0) continue;
                int u = random.m_188503_(3) + 2;
                for (int v = 0; v < u; ++v) {
                    this.m_226187_(level, biConsumer, random, new BlockPos(x + offsetX, foliageY - v - 1, z + offsetZ), treeConfiguration);
                }
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(foliageX + offsetX, foliageY, foliageZ + offsetZ), 0, false));
            }
        }
        ArrayList directions = Lists.newArrayList();
        for (int i = 0; i < 1 + random.m_188503_(4); ++i) {
            this.makeBranch(level, biConsumer, random, list, directions, foliageX, y, foliageZ, trunkHeight - Mth.m_216287_((RandomSource)random, (int)8, (int)13), trunkHeight, treeConfiguration);
        }
        return list;
    }

    public void makeBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource random, List<FoliagePlacer.FoliageAttachment> foliage, List<HorizontalDirection> directions, int foliageX, int genY, int foliageZ, int branchY, int trunkHeight, TreeConfiguration config) {
        HorizontalDirection lastDirection = null;
        for (int i = 0; i < 2; ++i) {
            int yy;
            HorizontalDirection direction;
            if (lastDirection == null) {
                direction = HorizontalDirection.random((RandomSource)random);
                while (directions.contains(direction)) {
                    direction = HorizontalDirection.random((RandomSource)random);
                }
                directions.add(direction);
                directions.add(direction.opposite());
                lastDirection = direction;
            } else {
                direction = lastDirection.opposite();
                lastDirection = null;
            }
            int genX = foliageX + direction.x;
            int genZ = foliageZ + direction.z;
            int offsetCount = 0;
            for (yy = branchY; yy < trunkHeight - 5 + random.m_188503_(4); ++yy) {
                int placeGenY = genY + yy;
                BlockPos placePos2 = new BlockPos(genX, placeGenY, genZ);
                if (TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)placePos2)) {
                    this.m_226187_(level, biConsumer, random, placePos2, config);
                    this.m_226187_(level, biConsumer, random, placePos2.m_122029_(), config);
                    this.m_226187_(level, biConsumer, random, placePos2.m_122019_(), config);
                    this.m_226187_(level, biConsumer, random, placePos2.m_122029_().m_122019_(), config);
                }
                if (!random.m_188499_() || offsetCount > 5) continue;
                ++offsetCount;
                if (direction.isStraight) {
                    genX += direction.x;
                    genZ += direction.z;
                    continue;
                }
                if (yy % 2 == 0) {
                    genX += direction.x;
                    continue;
                }
                genZ += direction.z;
            }
            foliage.add(new FoliagePlacer.FoliageAttachment(new BlockPos(genX, genY + yy + 1, genZ), 1, false));
        }
    }
}

