/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import party.lemons.biomemakeover.entity.TumbleweedEntity;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMFeatures;
import party.lemons.biomemakeover.level.BMWorldEvents;
import party.lemons.biomemakeover.util.RandomUtil;

public class TumbleweedSpawner {
    static final List<TumbleweedPlayerGroup> groups = Lists.newArrayList();

    public static void update(ServerLevel level) {
        if (!level.m_46469_().m_46207_(BMWorldEvents.RULE_TUMBLEWEED_SPAWNING)) {
            return;
        }
        groups.clear();
        for (ServerPlayer pl : level.m_8795_(p -> {
            BlockPos pos = BlockPos.m_274446_((Position)p.m_20182_());
            return level.m_46749_(pos) && level.m_204166_(pos).m_203656_(BMFeatures.HAS_TUMBLEWEED);
        })) {
            if (pl.m_5833_()) continue;
            boolean added = false;
            for (TumbleweedPlayerGroup group : groups) {
                if (!group.addPlayer(pl)) continue;
                added = true;
                break;
            }
            if (added) continue;
            groups.add(new TumbleweedPlayerGroup(pl));
        }
        for (TumbleweedPlayerGroup group : groups) {
            BlockPos pos;
            if (level.f_46441_.m_188503_(200) != 0 || (pos = group.getSpawnPos()) == null || !level.m_46749_(pos)) continue;
            int yHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
            if (!level.m_204166_(pos = new BlockPos(pos.m_123341_(), yHeight, pos.m_123343_())).m_203656_(BiomeTags.f_207607_)) continue;
            TumbleweedEntity tumble = (TumbleweedEntity)((EntityType)BMEntities.TUMBLEWEED.get()).m_20615_((Level)level);
            tumble.m_6027_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
            level.m_7967_((Entity)tumble);
        }
    }

    private static class TumbleweedPlayerGroup {
        private static final int MAX_DISTANCE = 50;
        private final ServerPlayer main;
        private final List<ServerPlayer> nearPlayers;

        private TumbleweedPlayerGroup(ServerPlayer main) {
            this.main = main;
            this.nearPlayers = Lists.newArrayList((Object[])new ServerPlayer[]{main});
        }

        public boolean addPlayer(ServerPlayer playerEntity) {
            if (playerEntity.m_20270_((Entity)this.main) <= 50.0f) {
                this.nearPlayers.add(playerEntity);
                return true;
            }
            return false;
        }

        public BlockPos getSpawnPos() {
            BlockPos pos;
            int spawnZ;
            int spawnX;
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (ServerPlayer p : this.nearPlayers) {
                if (p.m_20185_() + 20.0 + 45.0 > (double)maxX) {
                    maxX = (int)p.m_20185_() + 20 + 45;
                }
                if (p.m_20189_() + 20.0 + 45.0 > (double)maxZ) {
                    maxZ = (int)p.m_20189_() + 20 + 45;
                }
                if (p.m_20185_() - 20.0 - 45.0 < (double)minX) {
                    minX = (int)p.m_20185_() - 20 - 45;
                }
                if (!(p.m_20189_() - 20.0 - 45.0 < (double)minZ)) continue;
                minZ = (int)p.m_20189_() - 20 - 45;
            }
            int attempts = 20;
            do {
                spawnX = RandomUtil.randomRange(minX, maxX);
                spawnZ = RandomUtil.randomRange(minZ, maxZ);
                pos = new BlockPos(spawnX, 0, spawnZ);
            } while (!this.isOutOfRange(spawnX, spawnZ) && attempts-- > 0);
            if (attempts <= 0) {
                return null;
            }
            return pos;
        }

        private boolean isOutOfRange(double x, double z) {
            for (ServerPlayer pl : this.nearPlayers) {
                if (!(pl.m_20275_(x, pl.m_20186_(), z) < 20.0)) continue;
                return false;
            }
            return true;
        }
    }
}

